/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.vault.format;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.AbstractJeapCryptoDataFormat;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.DataFormatIdentifier;
import ch.admin.bit.jeap.crypto.internal.core.model.EncryptedDataKey;
import ch.admin.bit.jeap.crypto.internal.core.model.JeapCryptoContainer;
import ch.admin.bit.jeap.crypto.vault.keymanagement.VaultEncryptedDataKey;
import java.nio.ByteBuffer;

public class JeapCryptoCompactDataFormat
extends AbstractJeapCryptoDataFormat {
    private static final int FORMAT_FIELD_LENGTH = 1;
    private static final int KEY_VERSION_FIELD_LENGTH = 4;

    public ByteBuffer formatToByteBuffer(JeapCryptoContainer cryptoContainer) {
        byte[] encryptedDataKey = cryptoContainer.encryptedDataKey().ciphertext();
        byte[] nonce = cryptoContainer.nonce();
        byte[] ciphertext = cryptoContainer.ciphertext();
        JeapCryptoCompactDataFormat.assertFieldLength((byte[])encryptedDataKey, (int)60, (String)"dataKey");
        JeapCryptoCompactDataFormat.assertFieldLength((byte[])nonce, (int)12, (String)"nonce");
        JeapCryptoCompactDataFormat.assertCiphertextNotEmpty((int)ciphertext.length);
        VaultEncryptedDataKey dataKey = (VaultEncryptedDataKey)cryptoContainer.encryptedDataKey();
        int wrappingKeyVersion = dataKey.wrappingKeyVersion();
        int length = this.calculateSize(cryptoContainer);
        return ByteBuffer.allocate(length).put(DataFormatIdentifier.COMPACT_FORMAT_IDENTIFIER.formatId()).putInt(wrappingKeyVersion).put(encryptedDataKey).put(nonce).put(ciphertext);
    }

    public JeapCryptoContainer parse(byte[] dataContainerBytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(dataContainerBytes);
        JeapCryptoCompactDataFormat.assertFormatIdentifierIsForCompactFormat(byteBuffer);
        int wrappingKeyVersion = byteBuffer.getInt();
        byte[] encryptedDataKeyBytes = JeapCryptoCompactDataFormat.getEncryptedDataKey((ByteBuffer)byteBuffer);
        byte[] nonce = JeapCryptoCompactDataFormat.getNonce((ByteBuffer)byteBuffer);
        byte[] ciphertext = JeapCryptoCompactDataFormat.getCiphertext((ByteBuffer)byteBuffer);
        JeapCryptoCompactDataFormat.assertBufferHasNoRemainingBytes((ByteBuffer)byteBuffer);
        VaultEncryptedDataKey encryptedDataKey = new VaultEncryptedDataKey(encryptedDataKeyBytes, null, wrappingKeyVersion);
        return new JeapCryptoContainer((EncryptedDataKey)encryptedDataKey, nonce, ciphertext);
    }

    private static void assertFormatIdentifierIsForCompactFormat(ByteBuffer byteBuffer) {
        byte formatIdentifier = byteBuffer.get();
        if (formatIdentifier != DataFormatIdentifier.COMPACT_FORMAT_IDENTIFIER.formatId()) {
            throw CryptoException.badContainerFormatIdentifier((byte)formatIdentifier);
        }
    }

    private int calculateSize(JeapCryptoContainer cryptoContainer) {
        if (cryptoContainer.nonce().length != 12) {
            throw CryptoException.badNonceLength((int)cryptoContainer.nonce().length, (int)12);
        }
        byte[] encryptedDataKey = cryptoContainer.encryptedDataKey().ciphertext();
        if (encryptedDataKey.length != 60) {
            throw CryptoException.badKeySize((int)encryptedDataKey.length, (int)60);
        }
        return 77 + cryptoContainer.ciphertext().length;
    }

    public boolean canParse(byte[] dataContainerBytes) {
        return dataContainerBytes.length > 0 && dataContainerBytes[0] == DataFormatIdentifier.COMPACT_FORMAT_IDENTIFIER.formatId();
    }
}

