/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.vault.format;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.AbstractJeapCryptoDataFormat;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.DataFormatIdentifier;
import ch.admin.bit.jeap.crypto.internal.core.model.EncryptedDataKey;
import ch.admin.bit.jeap.crypto.internal.core.model.JeapCryptoContainer;
import ch.admin.bit.jeap.crypto.vault.keymanagement.VaultEncryptedDataKey;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class JeapCryptoKeyReferenceDataFormat
extends AbstractJeapCryptoDataFormat {
    private static final int AUTH_TAG_LENGTH = 16;
    private static final int NONCE_LENGTH = 12;
    private static final int AES_256_KEY_SIZE = 32;
    private static final int DATA_KEY_FIELD_LENGTH = 60;
    private static final int FORMAT_FIELD_LENGTH = 1;
    private static final int KEY_VERSION_FIELD_LENGTH = 4;
    private static final int KEY_PATH_LENGTH_FIELD_LENGTH = 4;
    private static final int NONCE_FIELD_LENGTH = 12;

    public ByteBuffer formatToByteBuffer(JeapCryptoContainer cryptoContainer) {
        VaultEncryptedDataKey encryptedDataKey = (VaultEncryptedDataKey)cryptoContainer.encryptedDataKey();
        byte[] wrappingKeyReferenceBytes = JeapCryptoKeyReferenceDataFormat.getWrappingKeyReferenceBytes((EncryptedDataKey)encryptedDataKey);
        int length = this.calculateSize(cryptoContainer, wrappingKeyReferenceBytes.length);
        byte[] dataKeyCiphertext = encryptedDataKey.ciphertext();
        byte[] nonce = cryptoContainer.nonce();
        byte[] ciphertext = cryptoContainer.ciphertext();
        JeapCryptoKeyReferenceDataFormat.assertFieldLength((byte[])dataKeyCiphertext, (int)60, (String)"dataKey");
        JeapCryptoKeyReferenceDataFormat.assertFieldLength((byte[])nonce, (int)12, (String)"nonce");
        JeapCryptoKeyReferenceDataFormat.assertCiphertextNotEmpty((int)ciphertext.length);
        int wrappingKeyVersion = encryptedDataKey.wrappingKeyVersion();
        return ByteBuffer.allocate(length).put(DataFormatIdentifier.KEY_REFERENCE_FORMAT_IDENTIFIER.formatId()).putInt(wrappingKeyReferenceBytes.length).put(wrappingKeyReferenceBytes).putInt(wrappingKeyVersion).put(dataKeyCiphertext).put(nonce).put(ciphertext);
    }

    private static byte[] getWrappingKeyReferenceBytes(EncryptedDataKey encryptedDataKey) {
        return encryptedDataKey.requireWrappingKeyReference().keyLocation().getBytes(StandardCharsets.UTF_8);
    }

    public JeapCryptoContainer parse(byte[] dataContainerBytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(dataContainerBytes);
        JeapCryptoKeyReferenceDataFormat.assertFormatIdentifierIsForKeyReferenceFormat(byteBuffer);
        KeyReference wrappingKeyReference = JeapCryptoKeyReferenceDataFormat.getKeyReference(byteBuffer);
        int wrappingKeyVersion = byteBuffer.getInt();
        byte[] encryptedDataKeyBytes = JeapCryptoKeyReferenceDataFormat.getEncryptedDataKey((ByteBuffer)byteBuffer);
        byte[] nonce = JeapCryptoKeyReferenceDataFormat.getNonce((ByteBuffer)byteBuffer);
        byte[] ciphertext = JeapCryptoKeyReferenceDataFormat.getCiphertext((ByteBuffer)byteBuffer);
        JeapCryptoKeyReferenceDataFormat.assertBufferHasNoRemainingBytes((ByteBuffer)byteBuffer);
        VaultEncryptedDataKey encryptedDataKey = new VaultEncryptedDataKey(encryptedDataKeyBytes, wrappingKeyReference, wrappingKeyVersion);
        return new JeapCryptoContainer((EncryptedDataKey)encryptedDataKey, nonce, ciphertext);
    }

    private static void assertFormatIdentifierIsForKeyReferenceFormat(ByteBuffer byteBuffer) {
        byte formatIdentifier = byteBuffer.get();
        if (formatIdentifier != DataFormatIdentifier.KEY_REFERENCE_FORMAT_IDENTIFIER.formatId()) {
            throw CryptoException.badContainerFormatIdentifier((byte)formatIdentifier);
        }
    }

    private static KeyReference getKeyReference(ByteBuffer byteBuffer) {
        int wrappingKeyLocationLength = byteBuffer.getInt();
        String wrappingKeyLocation = new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), wrappingKeyLocationLength, StandardCharsets.UTF_8);
        byteBuffer.position(byteBuffer.position() + wrappingKeyLocationLength);
        return new KeyReference(wrappingKeyLocation);
    }

    private int calculateSize(JeapCryptoContainer cryptoContainer, int keyReferenceLength) {
        if (cryptoContainer.nonce().length != 12) {
            throw CryptoException.badNonceLength((int)cryptoContainer.nonce().length, (int)12);
        }
        byte[] encryptedDataKey = cryptoContainer.encryptedDataKey().ciphertext();
        if (encryptedDataKey.length != 60) {
            throw CryptoException.badKeySize((int)encryptedDataKey.length, (int)60);
        }
        return 5 + keyReferenceLength + 4 + 60 + 12 + cryptoContainer.ciphertext().length;
    }

    public boolean canParse(byte[] dataContainerBytes) {
        return dataContainerBytes.length > 0 && dataContainerBytes[0] == DataFormatIdentifier.KEY_REFERENCE_FORMAT_IDENTIFIER.formatId();
    }
}

