/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.dbschema.publisher;

import brave.Span;
import brave.Tracer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

class TracingTimer {
    private static final String TAG_STATUS = "status";
    private static final String STATUS_SUCCESS = "success";
    private static final String STATUS_ERROR = "error";
    private final Tracer tracer;
    private final MeterRegistry meterRegistry;

    TracingTimer(Tracer tracer, MeterRegistry meterRegistry) {
        this.tracer = tracer;
        this.meterRegistry = meterRegistry;
    }

    CompletableFuture<Void> traceAndTime(String spanName, String timerName, Supplier<CompletableFuture<Void>> action) {
        Span span = this.tracer != null ? this.tracer.nextSpan().name(spanName).start() : null;
        Timer.Sample sample = this.meterRegistry != null ? Timer.start((MeterRegistry)this.meterRegistry) : null;
        try {
            CompletionStage completionStage;
            block10: {
                Tracer.SpanInScope ignored = span != null ? this.tracer.withSpanInScope(span) : null;
                try {
                    completionStage = action.get().whenComplete((result, ex) -> this.stopTimer(timerName, sample, (Throwable)ex));
                    if (ignored == null) break block10;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return completionStage;
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    private void stopTimer(String timerName, Timer.Sample sample, Throwable ex) {
        if (sample != null) {
            String status = ex != null ? STATUS_ERROR : STATUS_SUCCESS;
            sample.stop(this.meterRegistry.timer(timerName, new String[]{TAG_STATUS, status}));
        }
    }
}

