/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.dbschema.publisher;

import ch.admin.bit.jeap.dbschema.archrepo.client.ArchitectureRepositoryService;
import ch.admin.bit.jeap.dbschema.archrepo.client.CreateOrUpdateDbSchemaDto;
import ch.admin.bit.jeap.dbschema.model.DatabaseSchema;
import ch.admin.bit.jeap.dbschema.publisher.ArchRepoProperties;
import ch.admin.bit.jeap.dbschema.publisher.TracingTimer;
import ch.admin.bit.jeap.dbschema.reader.DatabaseModelReader;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.scheduling.annotation.Async;

class DbSchemaPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbSchemaPublisher.class);
    static final String DB_SCHEMA_PUBLISHER_TASK_EXECUTOR = "dbSchemaPublisherTaskExecutor";
    private static final String TIMER_NAME = "jeap-publish-database-schema";
    private static final String SPAN_NAME = "publish-db-schema";
    private final String applicationName;
    private final ArchRepoProperties properties;
    private final ArchitectureRepositoryService architectureRepositoryService;
    private final DataSource dataSource;
    private final DatabaseModelReader databaseModelReader;
    private final BuildProperties buildProperties;
    private final GitProperties gitProperties;
    private final TracingTimer tracingTimer;

    DbSchemaPublisher(String applicationName, ArchRepoProperties properties, ArchitectureRepositoryService architectureRepositoryService, DataSource dataSource, DatabaseModelReader databaseModelReader, BuildProperties buildProperties, GitProperties gitProperties, TracingTimer tracingTimer) {
        this.applicationName = applicationName;
        this.properties = properties;
        this.architectureRepositoryService = architectureRepositoryService;
        this.dataSource = dataSource;
        this.databaseModelReader = databaseModelReader;
        this.buildProperties = buildProperties;
        this.gitProperties = gitProperties;
        this.tracingTimer = tracingTimer;
    }

    @Async(value="dbSchemaPublisherTaskExecutor")
    public CompletableFuture<Void> publishDatabaseSchemaAsync() {
        return this.tracingTimer.traceAndTime(SPAN_NAME, TIMER_NAME, () -> {
            try {
                this.publishDatabaseSchema();
                return CompletableFuture.completedFuture(null);
            }
            catch (SQLException e) {
                log.error("Failed to read database schema", (Throwable)e);
                return CompletableFuture.failedFuture(e);
            }
            catch (Exception e) {
                log.error("Failed to publish database schema", (Throwable)e);
                return CompletableFuture.failedFuture(e);
            }
        });
    }

    void publishDatabaseSchema() throws SQLException {
        log.debug("Reading database schema from {} schema", (Object)this.properties.getSchemaName());
        DatabaseSchema databaseSchema = this.databaseModelReader.readDatabaseModel(this.dataSource, this.properties.getSchemaName(), this.getAppVersion());
        CreateOrUpdateDbSchemaDto dto = new CreateOrUpdateDbSchemaDto(this.applicationName, databaseSchema);
        log.info("Publishing schema DTO: componentName={}, tableCount={} to {} with client registration {}", new Object[]{dto.systemComponentName(), dto.schema().tables().size(), this.properties.getUrl(), this.properties.getOauthClient()});
        this.architectureRepositoryService.publishDbSchema(dto);
        log.info("Published database schema successfully");
    }

    private String getAppVersion() {
        String gitBuildVersion;
        if (this.buildProperties != null) {
            return this.buildProperties.getVersion();
        }
        if (this.gitProperties != null && (gitBuildVersion = this.gitProperties.get("git.build.version")) != null) {
            return gitBuildVersion;
        }
        return "na";
    }
}

