/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen.service;

import ch.admin.bit.jeap.deploymentlog.docgen.DocumentationGeneratorProperties;
import ch.admin.bit.jeap.deploymentlog.docgen.model.Color;
import ch.admin.bit.jeap.deploymentlog.docgen.model.ComponentDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.ComponentEnvDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.DeploymentDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.DeploymentLetterPageDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.LinkDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.SystemPageDto;
import ch.admin.bit.jeap.deploymentlog.domain.ArtifactVersion;
import ch.admin.bit.jeap.deploymentlog.domain.ArtifactVersionRepository;
import ch.admin.bit.jeap.deploymentlog.domain.Changelog;
import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentListPage;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentListPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPage;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentSequence;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentTarget;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentUnit;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionState;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionStateRepository;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentHistoryPage;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentHistoryPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.Link;
import ch.admin.bit.jeap.deploymentlog.domain.Reference;
import ch.admin.bit.jeap.deploymentlog.domain.ReferenceRepository;
import ch.admin.bit.jeap.deploymentlog.domain.ReferenceType;
import ch.admin.bit.jeap.deploymentlog.domain.System;
import ch.admin.bit.jeap.deploymentlog.domain.SystemPage;
import ch.admin.bit.jeap.deploymentlog.domain.SystemPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.VersionNumber;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GeneratorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneratorService.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final EnvironmentRepository environmentRepository;
    private final DeploymentRepository deploymentRepository;
    private final SystemPageRepository systemPageRepository;
    private final EnvironmentHistoryPageRepository environmentHistoryPageRepository;
    private final DeploymentListPageRepository deploymentListPageRepository;
    private final DeploymentPageRepository deploymentPageRepository;
    private final EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository;
    private final ArtifactVersionRepository artifactVersionRepository;
    private final ReferenceRepository referenceRepository;
    private final DocumentationGeneratorProperties documentationGeneratorProperties;

    public SystemPageDto createSystemPageDto(System system) {
        List environmentList = this.environmentRepository.findEnvironmentsForSystem(system);
        List<String> environmentNamesList = environmentList.stream().map(Environment::getName).toList();
        List componentList = this.environmentComponentVersionStateRepository.findComponentsBySystem(system);
        List<ComponentDto> componentDtos = componentList.stream().map(component -> ComponentDto.builder().componentName(component.getName()).componentEnvDtoList(this.createComponentEnvDtoList((Component)component, environmentList)).build()).sorted(Comparator.comparing(ComponentDto::getComponentName)).toList();
        return SystemPageDto.builder().name(system.getName()).environmentNamesArrayList(environmentNamesList).componentList(componentDtos).build();
    }

    private List<ComponentEnvDto> createComponentEnvDtoList(Component component, List<Environment> environmentList) {
        ArrayList<ComponentEnvDto> componentEnvDtoList = new ArrayList<ComponentEnvDto>();
        environmentList.forEach(environment -> {
            Optional envCompOpt = this.environmentComponentVersionStateRepository.findByEnvironmentAndComponent(environment, component);
            if (envCompOpt.isPresent()) {
                EnvironmentComponentVersionState envCompVersionState = (EnvironmentComponentVersionState)envCompOpt.get();
                ComponentEnvDto componentEnvDto = ComponentEnvDto.builder().versionNumber(envCompVersionState.getComponentVersion().getVersionNumber()).versionName(envCompVersionState.getComponentVersion().getVersionName()).versionControlUrl(envCompVersionState.getComponentVersion().getVersionControlUrl()).deployedAt(this.getStartedAtFormatted(envCompVersionState.getDeployment())).deploymentLetterUrl(this.createDeploymentLetterLink(envCompVersionState.getDeployment())).color(Color.NONE).developmentEnvironment(environment.isDevelopment()).build();
                componentEnvDtoList.add(componentEnvDto);
            } else {
                ComponentEnvDto componentEnvDto = ComponentEnvDto.builder().color(Color.NONE).build();
                componentEnvDtoList.add(componentEnvDto);
            }
        });
        List<ComponentEnvDto> componentNonDevelopmentEnvDtoList = componentEnvDtoList.stream().filter(env -> !env.isDevelopmentEnvironment()).toList();
        if (this.verifyAllVersionAreEquals(componentNonDevelopmentEnvDtoList)) {
            componentNonDevelopmentEnvDtoList.forEach(dto -> dto.setColor(Color.ALL_IDENTICAL));
            return componentEnvDtoList;
        }
        for (int index = 0; index < componentNonDevelopmentEnvDtoList.size(); ++index) {
            ComponentEnvDto actualComponentEnvDto = componentNonDevelopmentEnvDtoList.get(index);
            try {
                ComponentEnvDto nextcomponentEnvDto = componentNonDevelopmentEnvDtoList.get(index + 1);
                Color detectedColor = this.verifyNextStage(actualComponentEnvDto, nextcomponentEnvDto);
                actualComponentEnvDto.setColor(detectedColor);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
        }
        return componentEnvDtoList;
    }

    private String getStartedAtFormatted(Deployment deployment) {
        return deployment.getStartedAt().withZoneSameInstant(ZoneId.systemDefault()).format(DATE_TIME_FORMATTER);
    }

    private String getEndedAtFormatted(Deployment deployment) {
        return deployment.getEndedAt() == null ? "" : deployment.getEndedAt().withZoneSameInstant(ZoneId.systemDefault()).format(DATE_TIME_FORMATTER);
    }

    private boolean verifyAllVersionAreEquals(List<ComponentEnvDto> componentEnvDtoList) {
        if (componentEnvDtoList.stream().allMatch(dto -> dto.getVersionNumber() == null)) {
            return false;
        }
        return componentEnvDtoList.stream().map(ComponentEnvDto::getVersionNumber).distinct().count() <= 1L;
    }

    private Color verifyNextStage(ComponentEnvDto actualStage, ComponentEnvDto nextStage) {
        if (actualStage.getVersionNumber() == null && nextStage.getVersionNumber() == null) {
            return Color.NONE;
        }
        if (nextStage == null || nextStage.getVersionNumber() == null) {
            return Color.MISSES_NEXT_STAGE;
        }
        if (actualStage.getVersionNumber() == null) {
            return Color.NONE;
        }
        if (this.isNextVersionLower(actualStage.getVersionNumber(), nextStage.getVersionNumber())) {
            return Color.HIGHER_THAN_NEXT_STAGE;
        }
        return Color.NONE;
    }

    private boolean isNextVersionLower(VersionNumber actualVersion, VersionNumber nextVersion) {
        return nextVersion.compareTo(actualVersion) < 0;
    }

    private String createDeploymentLetterLink(Deployment deployment) {
        String componentName = deployment.getComponentVersion().getComponent().getName();
        String startedAtFormatted = this.getStartedAtFormatted(deployment);
        String deploymentLetterLink = startedAtFormatted + " " + componentName + " (" + deployment.getEnvironment().getName() + ")";
        if (DeploymentSequence.UNDEPLOYED.equals((Object)deployment.getSequence())) {
            deploymentLetterLink = deploymentLetterLink + " (Undeploy)";
        }
        return deploymentLetterLink;
    }

    public List<Environment> getEnvironmentsForSystem(System system) {
        return this.environmentRepository.findEnvironmentsForSystem(system);
    }

    public List<DeploymentDto> getDeploymentsForSystemAndEnv(System system, Environment environment, int maxShow) {
        List deploymentList = this.deploymentRepository.findDeploymentForSystemAndEnvLimited(system, environment, maxShow);
        return deploymentList.stream().map(deployment -> DeploymentDto.builder().deploymentId(deployment.getId().toString()).component(deployment.getComponentVersion().getComponent().getName()).startedAt(this.getStartedAtFormatted((Deployment)deployment)).duration(this.getDurationFormatted((Deployment)deployment)).version(deployment.getComponentVersion().getVersionName()).versionControlUrl(deployment.getComponentVersion().getVersionControlUrl()).deploymentLetterLink(this.createDeploymentLetterLink((Deployment)deployment)).startedBy(deployment.getStartedBy()).state(deployment.getState().toString()).build()).toList();
    }

    public List<DeploymentDto> getDeploymentsForEnv(Environment environment, ZonedDateTime minStartedAt, int maxShow) {
        List deploymentList = this.deploymentRepository.findDeploymentForEnvLimited(environment, minStartedAt, maxShow);
        return deploymentList.stream().map(deployment -> DeploymentDto.builder().deploymentId(deployment.getId().toString()).component(deployment.getComponentVersion().getComponent().getName()).system(deployment.getComponentVersion().getComponent().getSystem().getName()).startedAt(this.getStartedAtFormatted((Deployment)deployment)).duration(this.getDurationFormatted((Deployment)deployment)).version(deployment.getComponentVersion().getVersionName()).versionControlUrl(deployment.getComponentVersion().getVersionControlUrl()).deploymentLetterLink(this.createDeploymentLetterLink((Deployment)deployment)).startedBy(deployment.getStartedBy()).state(deployment.getState().toString()).build()).toList();
    }

    public List<Integer> getDeploymentsYearsForSystemAndEnv(System system, Environment environment) {
        return this.deploymentRepository.findAllDeploymentsYearsForSystemAndEnv(system, environment);
    }

    public List<DeploymentLetterPageDto> getDeploymentsForYearForSystemAndEnv(int year, System system, Environment environment) {
        List deploymentList = this.deploymentRepository.findAllDeploymentForSystemAndEnv(system, environment);
        return deploymentList.stream().filter(deployment -> deployment.getStartedAt().getYear() == year).map(this::createDeploymentLetterPageDto).toList();
    }

    public DeploymentLetterPageDto createDeploymentLetterPageDto(Deployment deployment) {
        DeploymentLetterPageDto.DeploymentLetterPageDtoBuilder dtoBuilder = DeploymentLetterPageDto.builder().deploymentId(deployment.getId().toString()).externalId(deployment.getExternalId()).environmentName(deployment.getEnvironment().getName()).startedAt(this.getStartedAtFormatted(deployment)).endedAt(this.getEndedAtFormatted(deployment)).startedBy(deployment.getStartedBy()).state(deployment.getState().toString()).stateMessage(GeneratorService.emptyStringForNull(deployment.getStateMessage())).duration(this.getDurationFormatted(deployment)).componentName(deployment.getComponentVersion().getComponent().getName()).version(deployment.getComponentVersion().getVersionName()).versionControlUrl(deployment.getComponentVersion().getVersionControlUrl()).links(this.getLinks(deployment)).properties(new TreeMap<String, String>(deployment.getProperties())).changeComment(this.getChangeLogComment(deployment)).changeComparedToVersion(this.getChangeLogComparedToVersion(deployment)).changeJiraIssueKeys(this.getChangeLogJiraIssueKeys(deployment)).deploymentStateTimestamp(deployment.getLastModified()).deploymentUnitType(deployment.getComponentVersion().getDeploymentUnit().getType().getLabel()).deploymentUnitCoordinates(this.formatCoordinates(deployment)).deploymentUnitRepositoryUrl(deployment.getComponentVersion().getDeploymentUnit().getArtifactRepositoryUrl()).sequence(deployment.getSequence().getLabel()).remedyChangeId(deployment.getRemedyChangeId()).remedyChangeLink(this.getRemedyChangeLink(deployment.getRemedyChangeId())).buildJobLinks(this.getBuildJobLinks(deployment.getComponentVersion().getDeploymentUnit(), deployment.getReferenceIdentifiers()));
        DeploymentTarget target = deployment.getTarget();
        if (target != null) {
            dtoBuilder.targetType(target.getType()).targetUrl(target.getUrl()).targetDetails(target.getDetails());
        }
        return dtoBuilder.build();
    }

    public DeploymentLetterPageDto createUndeploymentLetterPageDto(Deployment deployment) {
        DeploymentLetterPageDto.DeploymentLetterPageDtoBuilder dtoBuilder = DeploymentLetterPageDto.builder().deploymentId(deployment.getId().toString()).externalId(deployment.getExternalId()).environmentName(deployment.getEnvironment().getName()).startedAt(this.getStartedAtFormatted(deployment)).endedAt(this.getEndedAtFormatted(deployment)).startedBy(deployment.getStartedBy()).state(deployment.getState().toString()).stateMessage(GeneratorService.emptyStringForNull(deployment.getStateMessage())).duration(this.getDurationFormatted(deployment)).componentName(deployment.getComponentVersion().getComponent().getName()).deploymentStateTimestamp(deployment.getLastModified()).deploymentUnitType(deployment.getComponentVersion().getDeploymentUnit().getType().getLabel()).deploymentUnitCoordinates(this.formatCoordinates(deployment)).deploymentUnitRepositoryUrl(deployment.getComponentVersion().getDeploymentUnit().getArtifactRepositoryUrl()).sequence(deployment.getSequence().getLabel()).remedyChangeId(deployment.getRemedyChangeId()).remedyChangeLink(this.getRemedyChangeLink(deployment.getRemedyChangeId())).buildJobLinks(this.getBuildJobLinks(deployment.getComponentVersion().getDeploymentUnit(), deployment.getReferenceIdentifiers()));
        return dtoBuilder.build();
    }

    private Set<String> getBuildJobLinks(DeploymentUnit deploymentUnit, Set<String> referenceIdentifiers) {
        HashSet<String> buildJobLinks = new HashSet<String>();
        if (referenceIdentifiers != null) {
            referenceIdentifiers.forEach(refIdOnDeployment -> buildJobLinks.addAll(this.referenceRepository.findAllByReferenceIdentifier(refIdOnDeployment).stream().filter(ref -> ref.getType() == ReferenceType.BUILD_JOB_LINK_BY_GIT_URL_AND_VERSION).map(Reference::getUri).collect(Collectors.toSet())));
        }
        if (!StringUtils.hasText((String)deploymentUnit.getCoordinates())) {
            return buildJobLinks;
        }
        buildJobLinks.addAll(this.artifactVersionRepository.findAllByCoordinates(deploymentUnit.getCoordinates()).stream().map(ArtifactVersion::getBuildJobLink).collect(Collectors.toSet()));
        return buildJobLinks;
    }

    private String getRemedyChangeLink(String remedyChangeId) {
        if (remedyChangeId == null) {
            return null;
        }
        return this.documentationGeneratorProperties.getRemedyChangeLinkRootUrlWithTrailingSlash() + remedyChangeId;
    }

    private String formatCoordinates(Deployment deployment) {
        String coordinates = deployment.getComponentVersion().getDeploymentUnit().getCoordinates();
        return coordinates.isEmpty() ? "Link" : coordinates;
    }

    private static String emptyStringForNull(String str) {
        return str == null ? "" : str;
    }

    private String getDurationFormatted(Deployment deployment) {
        if (deployment.getEndedAt() != null) {
            Duration duration = Duration.between(deployment.getStartedAt(), deployment.getEndedAt());
            long hours = duration.toHours();
            long minutes = duration.toMinutesPart();
            long seconds = duration.toSecondsPart();
            return "%02d:%02d:%02d".formatted(hours, minutes, seconds);
        }
        return "";
    }

    private Set<String> getChangeLogJiraIssueKeys(Deployment deployment) {
        Changelog changelog = deployment.getChangelog();
        if (changelog != null) {
            return changelog.getJiraIssueKeys();
        }
        return Set.of();
    }

    private String getChangeLogComparedToVersion(Deployment deployment) {
        Changelog changelog = deployment.getChangelog();
        if (changelog != null) {
            return changelog.getComparedToVersion();
        }
        return "";
    }

    private String getChangeLogComment(Deployment deployment) {
        Changelog changelog = deployment.getChangelog();
        if (changelog != null) {
            return changelog.getComment();
        }
        return "";
    }

    private List<LinkDto> getLinks(Deployment deployment) {
        return deployment.getLinks().stream().sorted(Comparator.comparing(Link::getLabel)).map(link -> LinkDto.builder().linkLabel(link.getLabel()).linkUrl(link.getUrl()).build()).toList();
    }

    public void persistSystemPage(System system, String pageId) {
        Optional systemPageOpt = this.systemPageRepository.findSystemPageBySystemId(system.getId());
        systemPageOpt.ifPresentOrElse(systemPage -> {
            systemPage.setLastUpdatedAt(ZonedDateTime.now());
            systemPage.setSystemPageId(pageId);
            this.systemPageRepository.save(systemPage);
        }, () -> {
            SystemPage systemPage = SystemPage.builder().id(UUID.randomUUID()).systemId(system.getId()).systemPageId(pageId).lastUpdatedAt(ZonedDateTime.now()).build();
            this.systemPageRepository.save(systemPage);
        });
    }

    public void persistDeploymentHistoryPage(System system, Environment environment, String pageId) {
        Optional environmentHistoryPageOpt = this.environmentHistoryPageRepository.findEnvironmentHistoryPageBySystemIdAndEnvironmentId(system.getId(), environment.getId());
        environmentHistoryPageOpt.ifPresentOrElse(environmentHistoryPage -> {
            environmentHistoryPage.setLastUpdatedAt(ZonedDateTime.now());
            environmentHistoryPage.setPageId(pageId);
            this.environmentHistoryPageRepository.save(environmentHistoryPage);
        }, () -> {
            EnvironmentHistoryPage environmentHistoryPage = EnvironmentHistoryPage.builder().id(UUID.randomUUID()).systemId(system.getId()).environmentId(environment.getId()).pageId(pageId).lastUpdatedAt(ZonedDateTime.now()).build();
            this.environmentHistoryPageRepository.save(environmentHistoryPage);
        });
    }

    public void persistDeploymentListPage(System system, Environment environment, String pageId, int year) {
        Optional deploymentListPageOpt = this.deploymentListPageRepository.findDeploymentListPageBySystemIdAndEnvironmentIdAndYear(system.getId(), environment.getId(), year);
        deploymentListPageOpt.ifPresentOrElse(deploymentListPage -> {
            deploymentListPage.setLastUpdatedAt(ZonedDateTime.now());
            deploymentListPage.setPageId(pageId);
            this.deploymentListPageRepository.save(deploymentListPage);
        }, () -> {
            DeploymentListPage deploymentListPage = DeploymentListPage.builder().id(UUID.randomUUID()).systemId(system.getId()).environmentId(environment.getId()).pageId(pageId).lastUpdatedAt(ZonedDateTime.now()).year(year).build();
            this.deploymentListPageRepository.save(deploymentListPage);
        });
    }

    public void persistDeploymentPage(UUID deploymentId, String pageId, ZonedDateTime deploymentStateTimestamp) {
        Optional deploymentPageOpt = this.deploymentPageRepository.findDeploymentPageByDeploymentId(deploymentId);
        deploymentPageOpt.ifPresentOrElse(deploymentPage -> {
            deploymentPage.setLastUpdatedAt(ZonedDateTime.now());
            deploymentPage.setDeploymentStateTimestamp(deploymentStateTimestamp);
            deploymentPage.setPageId(pageId);
            this.deploymentPageRepository.save(deploymentPage);
        }, () -> {
            DeploymentPage deploymentPage = DeploymentPage.builder().id(UUID.randomUUID()).deploymentId(deploymentId).pageId(pageId).lastUpdatedAt(ZonedDateTime.now()).deploymentStateTimestamp(deploymentStateTimestamp).build();
            this.deploymentPageRepository.save(deploymentPage);
        });
    }

    @Generated
    public GeneratorService(EnvironmentRepository environmentRepository, DeploymentRepository deploymentRepository, SystemPageRepository systemPageRepository, EnvironmentHistoryPageRepository environmentHistoryPageRepository, DeploymentListPageRepository deploymentListPageRepository, DeploymentPageRepository deploymentPageRepository, EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository, ArtifactVersionRepository artifactVersionRepository, ReferenceRepository referenceRepository, DocumentationGeneratorProperties documentationGeneratorProperties) {
        this.environmentRepository = environmentRepository;
        this.deploymentRepository = deploymentRepository;
        this.systemPageRepository = systemPageRepository;
        this.environmentHistoryPageRepository = environmentHistoryPageRepository;
        this.deploymentListPageRepository = deploymentListPageRepository;
        this.deploymentPageRepository = deploymentPageRepository;
        this.environmentComponentVersionStateRepository = environmentComponentVersionStateRepository;
        this.artifactVersionRepository = artifactVersionRepository;
        this.referenceRepository = referenceRepository;
        this.documentationGeneratorProperties = documentationGeneratorProperties;
    }
}

