/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen.service;

import jakarta.annotation.PostConstruct;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="jeap.deploymentlog.documentation-generator.scheduled")
class SchedulingConfigProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulingConfigProperties.class);
    private int retriedPagesLimit = 50;
    private long minAgeMinutes = 5L;
    private long maxAgeMinutes = Duration.ofHours(24L).toMinutes();
    private String cron;
    private int keepDeploymentPagePerEnvCount = 200;

    @PostConstruct
    void init() {
        log.info("Scheduling configuration: {}", (Object)this);
        if (this.maxAgeMinutes <= this.minAgeMinutes || this.minAgeMinutes < 0L) {
            throw new IllegalArgumentException("Bad configuration: Must be 0 <= minAgeMinutes < maxAgeMinutes");
        }
    }

    @Generated
    public SchedulingConfigProperties() {
    }

    @Generated
    public int getRetriedPagesLimit() {
        return this.retriedPagesLimit;
    }

    @Generated
    public long getMinAgeMinutes() {
        return this.minAgeMinutes;
    }

    @Generated
    public long getMaxAgeMinutes() {
        return this.maxAgeMinutes;
    }

    @Generated
    public String getCron() {
        return this.cron;
    }

    @Generated
    public int getKeepDeploymentPagePerEnvCount() {
        return this.keepDeploymentPagePerEnvCount;
    }

    @Generated
    public void setRetriedPagesLimit(int retriedPagesLimit) {
        this.retriedPagesLimit = retriedPagesLimit;
    }

    @Generated
    public void setMinAgeMinutes(long minAgeMinutes) {
        this.minAgeMinutes = minAgeMinutes;
    }

    @Generated
    public void setMaxAgeMinutes(long maxAgeMinutes) {
        this.maxAgeMinutes = maxAgeMinutes;
    }

    @Generated
    public void setCron(String cron) {
        this.cron = cron;
    }

    @Generated
    public void setKeepDeploymentPagePerEnvCount(int keepDeploymentPagePerEnvCount) {
        this.keepDeploymentPagePerEnvCount = keepDeploymentPagePerEnvCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulingConfigProperties)) {
            return false;
        }
        SchedulingConfigProperties other = (SchedulingConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetriedPagesLimit() != other.getRetriedPagesLimit()) {
            return false;
        }
        if (this.getMinAgeMinutes() != other.getMinAgeMinutes()) {
            return false;
        }
        if (this.getMaxAgeMinutes() != other.getMaxAgeMinutes()) {
            return false;
        }
        if (this.getKeepDeploymentPagePerEnvCount() != other.getKeepDeploymentPagePerEnvCount()) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        return !(this$cron == null ? other$cron != null : !this$cron.equals(other$cron));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchedulingConfigProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetriedPagesLimit();
        long $minAgeMinutes = this.getMinAgeMinutes();
        result = result * 59 + (int)($minAgeMinutes >>> 32 ^ $minAgeMinutes);
        long $maxAgeMinutes = this.getMaxAgeMinutes();
        result = result * 59 + (int)($maxAgeMinutes >>> 32 ^ $maxAgeMinutes);
        result = result * 59 + this.getKeepDeploymentPagePerEnvCount();
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SchedulingConfigProperties(retriedPagesLimit=" + this.getRetriedPagesLimit() + ", minAgeMinutes=" + this.getMinAgeMinutes() + ", maxAgeMinutes=" + this.getMaxAgeMinutes() + ", cron=" + this.getCron() + ", keepDeploymentPagePerEnvCount=" + this.getKeepDeploymentPagePerEnvCount() + ")";
    }
}

