/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen;

import ch.admin.bit.jeap.deploymentlog.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.deploymentlog.docgen.DocumentationGeneratorConfluenceProperties;
import ch.admin.bit.jeap.deploymentlog.docgen.api.ConfluenceCustomRestClient;
import java.util.List;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluencePage;
import org.sahli.asciidoc.confluence.publisher.client.http.NotFoundException;
import org.sahli.asciidoc.confluence.publisher.client.http.RequestFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfluenceAdapterImpl
implements ConfluenceAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceAdapterImpl.class);
    static final String CONTENT_HASH_PROPERTY_KEY = "content-hash";
    private static final String VERSION_MESSAGE = "Documentation generated";
    private final ConfluenceClient confluenceClient;
    private final DocumentationGeneratorConfluenceProperties props;
    private final ConfluenceCustomRestClient confluenceCustomRestClient;

    private static boolean notSameHash(String actualHash, String newHash) {
        return actualHash == null || !actualHash.equals(newHash);
    }

    private static String hash(String content) {
        return DigestUtils.sha256Hex((String)content);
    }

    @Override
    public String getPageByName(String pageName) {
        return this.confluenceClient.getPageByTitle(this.props.getSpaceKey(), pageName);
    }

    @Override
    public String addOrUpdatePageUnderAncestor(String ancestorId, String pageName, String content) {
        String contentId;
        try {
            contentId = this.confluenceClient.getPageByTitle(this.props.getSpaceKey(), pageName);
            this.updatePage(contentId, ancestorId, pageName, content);
        }
        catch (NotFoundException e) {
            log.info("Creating page {}", (Object)pageName);
            contentId = this.confluenceClient.addPageUnderAncestor(this.props.getSpaceKey(), ancestorId, pageName, content, VERSION_MESSAGE);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, ConfluenceAdapterImpl.hash(content));
        }
        return contentId;
    }

    @Override
    public void movePage(String ancestorId, String contentId) {
        try {
            ConfluencePage existingPage = this.confluenceClient.getPageWithContentAndVersionById(contentId);
            log.info("Moving page {}", (Object)existingPage.getTitle());
            this.updatePageWithRetryOnConflict(contentId, ancestorId, existingPage.getTitle(), existingPage.getContent(), existingPage);
        }
        catch (NotFoundException e) {
            log.info("Page with id {} not found. Ignoring...", (Object)contentId);
        }
    }

    private void updatePage(String contentId, String ancestorId, String pageName, String content) {
        String newContentHash;
        ConfluencePage existingPage = this.confluenceClient.getPageWithContentAndVersionById(contentId);
        String existingContentHash = this.confluenceClient.getPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
        if (ConfluenceAdapterImpl.notSameHash(existingContentHash, newContentHash = ConfluenceAdapterImpl.hash(content)) || !existingPage.getTitle().equals(pageName)) {
            log.info("Updating page {}", (Object)pageName);
            this.updatePageWithRetryOnConflict(contentId, ancestorId, pageName, content, existingPage);
            this.confluenceClient.deletePropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY);
            this.confluenceClient.setPropertyByKey(contentId, CONTENT_HASH_PROPERTY_KEY, newContentHash);
        } else {
            log.info("Page {} is up-to-date", (Object)pageName);
        }
    }

    private void updatePageWithRetryOnConflict(String contentId, String ancestorId, String pageName, String content, ConfluencePage existingPage) {
        int retries = 0;
        while (true) {
            try {
                int newPageVersion = existingPage.getVersion() + 1;
                this.confluenceClient.updatePage(contentId, ancestorId, pageName, content, newPageVersion, VERSION_MESSAGE);
                return;
            }
            catch (RequestFailedException rfe) {
                if (!rfe.getMessage().contains("response: 409") || retries >= 2) {
                    throw rfe;
                }
                log.warn("Failed to update page content for page {} - will try again in {}ms ({})", new Object[]{contentId, this.props.getRetryOnConflictWaitDuration().toMillis(), rfe.getMessage()});
                this.waitForRetry();
                existingPage = this.confluenceClient.getPageWithContentAndVersionById(contentId);
                ++retries;
                continue;
            }
            break;
        }
    }

    private void waitForRetry() {
        Thread.sleep(this.props.getRetryOnConflictWaitDuration().toMillis());
    }

    @Override
    public void deletePage(String pageId) {
        try {
            this.confluenceClient.deletePage(pageId);
        }
        catch (RequestFailedException ex) {
            String message = ex.getMessage();
            if (message.contains("response: 404")) {
                log.info("Page {} does not exist, already deleted (status code 404)", (Object)pageId);
            }
            throw ex;
        }
    }

    @Override
    public void deletePageAndChildPages(String pageId) {
        List<String> childPages = this.confluenceClient.getChildPages(pageId).stream().map(ConfluencePage::getContentId).toList();
        log.info("Found {} childPages of {} to delete", (Object)childPages.size(), (Object)pageId);
        childPages.forEach(this::deletePageAndChildPages);
        log.info("Delete page with id {}", (Object)pageId);
        this.deletePage(pageId);
    }

    @Override
    public String createBlogpost(String spaceKey, String title, String content) {
        return this.confluenceCustomRestClient.createBlogpost(spaceKey, title, content);
    }

    @Generated
    public ConfluenceAdapterImpl(ConfluenceClient confluenceClient, DocumentationGeneratorConfluenceProperties props, ConfluenceCustomRestClient confluenceCustomRestClient) {
        this.confluenceClient = confluenceClient;
        this.props = props;
        this.confluenceCustomRestClient = confluenceCustomRestClient;
    }
}

