/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen.service;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;
import lombok.Generated;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class DocgenLocks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocgenLocks.class);
    private static final String LOCK_NAME_PREFIX = "docgen-";
    private static final Duration LOCK_RETRY_WAIT_DURATION = Duration.ofSeconds(3L);
    private static final Duration LOCK_AT_MOST_FOR = Duration.ofMinutes(1L);
    private static final Duration LOCK_AT_LEAST_FOR = Duration.ZERO;
    private Duration tryAcquireTimeout = Duration.ofMinutes(3L);
    private final LockProvider lockProvider;

    DocgenLocks(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    void runIfLockAquiredBeforeTimeout(String systemName, Runnable task) {
        String lockName = LOCK_NAME_PREFIX + systemName;
        this.tryAcquireLockWithTimeout(lockName).ifPresentOrElse(lock -> this.runLockedTask(task, lockName, (SimpleLock)lock), () -> log.warn("Unable to aquire lock {}, not running docgen. Pages will be generated by scheduled job.", (Object)lockName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLockedTask(Runnable task, String lockName, SimpleLock lock) {
        try {
            log.info("Acquired lock {}, running task", (Object)lockName);
            task.run();
        }
        finally {
            log.info("Releasing lock {}", (Object)lockName);
            lock.unlock();
        }
    }

    private Optional<SimpleLock> tryAcquireLockWithTimeout(String lockName) {
        LocalDateTime startedAt = LocalDateTime.now();
        int i = 1;
        while (true) {
            Optional lock;
            if ((lock = this.lockProvider.lock(this.newLockConfiguration(lockName))).isPresent() || this.waitedLongEnough(startedAt)) {
                return lock;
            }
            log.info("Docgen for this system name is busy - waiting to aquire lock {} (retry #{})...", (Object)lockName, (Object)i);
            Thread.sleep(LOCK_RETRY_WAIT_DURATION.toMillis());
            ++i;
        }
    }

    private boolean waitedLongEnough(LocalDateTime startedAt) {
        return LocalDateTime.now().isAfter(startedAt.plus(this.tryAcquireTimeout));
    }

    private LockConfiguration newLockConfiguration(String lockName) {
        return new LockConfiguration(Instant.now(), lockName.toLowerCase(), LOCK_AT_MOST_FOR, LOCK_AT_LEAST_FOR);
    }

    void setTryAcquireTimeout(Duration tryAcquireTimeout) {
        this.tryAcquireTimeout = tryAcquireTimeout;
    }
}

