/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen;

import ch.admin.bit.jeap.deploymentlog.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.deploymentlog.docgen.ConfluenceAdapterImpl;
import ch.admin.bit.jeap.deploymentlog.docgen.ConfluenceAdapterMock;
import ch.admin.bit.jeap.deploymentlog.docgen.DocumentationGeneratorConfluenceProperties;
import ch.admin.bit.jeap.deploymentlog.docgen.api.ConfluenceCustomRestClient;
import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.MeterRegistry;
import java.nio.charset.StandardCharsets;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceClient;
import org.sahli.asciidoc.confluence.publisher.client.http.ConfluenceRestClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.client.RestClient;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.spring6.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

@AutoConfiguration
@EnableScheduling
@EnableSchedulerLock(defaultLockAtMostFor="10m")
@EnableRetry
public class DocumentationGeneratorConfig {
    private static final String CV_TEMPLATE_PATH = "/template/documentation/";

    @Bean
    ConfluenceClient confluenceClient(DocumentationGeneratorConfluenceProperties props) {
        return new ConfluenceRestClient(props.getUrl(), true, null, props.getUsername(), props.getPassword());
    }

    @Bean
    @ConditionalOnMissingBean
    ConfluenceAdapter confluenceAdapter(ConfluenceClient confluenceClient, DocumentationGeneratorConfluenceProperties props, RestClient.Builder restClientBuilder) {
        if (props.isMockConfluenceClient()) {
            return new ConfluenceAdapterMock();
        }
        return new ConfluenceAdapterImpl(confluenceClient, props, new ConfluenceCustomRestClient(props, restClientBuilder));
    }

    @Bean
    SpringResourceTemplateResolver templateResolver(ApplicationContext applicationContext) {
        SpringResourceTemplateResolver templateResolver = new SpringResourceTemplateResolver();
        templateResolver.setApplicationContext(applicationContext);
        templateResolver.setPrefix("classpath:/template/documentation/");
        templateResolver.setSuffix(".html");
        templateResolver.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        templateResolver.setTemplateMode(TemplateMode.HTML);
        return templateResolver;
    }

    @Bean
    SpringTemplateEngine templateEngine(ApplicationContext applicationContext) {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver(applicationContext));
        templateEngine.setEnableSpringELCompiler(true);
        return templateEngine;
    }

    @ConditionalOnMissingBean
    @Bean
    public LockProvider lockProvider(DataSource dataSource) {
        return new JdbcTemplateLockProvider(JdbcTemplateLockProvider.Configuration.builder().withJdbcTemplate(new JdbcTemplate(dataSource)).usingDbTime().build());
    }

    @Bean
    TimedAspect timedAspect(MeterRegistry registry) {
        return new TimedAspect(registry);
    }
}

