/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen.api;

import ch.admin.bit.jeap.deploymentlog.docgen.DocumentationGeneratorConfluenceProperties;
import ch.admin.bit.jeap.deploymentlog.docgen.api.dto.ConfluenceApiLinks;
import ch.admin.bit.jeap.deploymentlog.docgen.api.dto.ConfluenceApiResponseDto;
import ch.admin.bit.jeap.deploymentlog.docgen.api.dto.ConfluenceBodyDto;
import ch.admin.bit.jeap.deploymentlog.docgen.api.dto.ConfluenceSpaceDto;
import ch.admin.bit.jeap.deploymentlog.docgen.api.dto.ConfluenceStorageDto;
import ch.admin.bit.jeap.deploymentlog.docgen.api.dto.CreateBlogpostDto;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriComponentsBuilder;

public class ConfluenceCustomRestClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfluenceCustomRestClient.class);
    private final RestClient restClient;

    public ConfluenceCustomRestClient(DocumentationGeneratorConfluenceProperties props, RestClient.Builder restClientBuilder) {
        ClientHttpRequestFactory timeoutRequestFactory = ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)ClientHttpRequestFactorySettings.DEFAULTS.withReadTimeout(Duration.ofSeconds(10L)));
        this.restClient = restClientBuilder.requestFactory(timeoutRequestFactory).defaultHeaders(header -> header.setBasicAuth(props.getUsername(), props.getPassword())).baseUrl(UriComponentsBuilder.fromHttpUrl((String)props.getUrl()).pathSegment(new String[]{"rest", "api", "content"}).build().toString()).build();
    }

    public String createBlogpost(String spaceKey, String title, String content) {
        log.debug("Call confluence api to create blogpost with title '{}' in space '{}'", (Object)title, (Object)spaceKey);
        CreateBlogpostDto createBlogpostDto = CreateBlogpostDto.builder().type("blogpost").space(ConfluenceSpaceDto.builder().key(spaceKey).build()).title(title).body(ConfluenceBodyDto.builder().storage(ConfluenceStorageDto.builder().value(content).representation("storage").build()).build()).build();
        ConfluenceApiResponseDto response = (ConfluenceApiResponseDto)this.restClient.post().contentType(MediaType.APPLICATION_JSON).body((Object)createBlogpostDto).retrieve().body(ConfluenceApiResponseDto.class);
        if (response != null) {
            ConfluenceApiLinks links = response.getConfluenceApiLinks();
            String blogpostLink = String.join((CharSequence)"", links.getBase(), links.getTinyui());
            log.info("Blogpost created with link '{}'", (Object)blogpostLink);
            return blogpostLink;
        }
        throw new IllegalStateException("Response is null");
    }
}

