/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen;

import ch.admin.bit.jeap.deploymentlog.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.deploymentlog.docgen.DocumentationGeneratorConfluenceProperties;
import ch.admin.bit.jeap.deploymentlog.docgen.JiraAdapter;
import ch.admin.bit.jeap.deploymentlog.docgen.TemplateRenderer;
import ch.admin.bit.jeap.deploymentlog.docgen.model.DeploymentDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.DeploymentHistoryOverviewPageDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.DeploymentHistoryPageDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.DeploymentLetterPageDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.DeploymentListPageDto;
import ch.admin.bit.jeap.deploymentlog.docgen.model.GeneratedDeploymentPageDto;
import ch.admin.bit.jeap.deploymentlog.docgen.service.GeneratorService;
import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentListPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPageQueryResult;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentSequence;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentHistoryPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.System;
import ch.admin.bit.jeap.deploymentlog.domain.SystemEnv;
import ch.admin.bit.jeap.deploymentlog.domain.SystemPage;
import ch.admin.bit.jeap.deploymentlog.domain.SystemPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.SystemRepository;
import io.micrometer.core.annotation.Timed;
import java.lang.invoke.CallSite;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class DocumentationGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentationGenerator.class);
    public static final String UNDEPLOY_PAGE_SUFFIX = " (Undeploy)";
    private final ConfluenceAdapter confluenceAdapter;
    private final JiraAdapter jiraAdapter;
    private final TemplateRenderer templateRenderer;
    private final DocumentationGeneratorConfluenceProperties props;
    private final SystemRepository systemRepository;
    private final EnvironmentRepository environmentRepository;
    private final GeneratorService generatorService;
    private final DeploymentRepository deploymentRepository;
    private final DeploymentPageRepository deploymentPageRepository;
    private final SystemPageRepository systemPageRepository;
    private final EnvironmentHistoryPageRepository environmentHistoryPageRepository;
    private final DeploymentListPageRepository deploymentListPageRepository;

    @Timed(value="deploymentlog_generate_deployment_page")
    @Transactional
    public GeneratedDeploymentPageDto generateDeploymentPages(UUID deploymentId) {
        String rootPageId = this.confluenceAdapter.getPageByName(this.props.getDeploymentsPageName());
        Deployment deployment = this.deploymentRepository.getById(deploymentId);
        Environment environment = deployment.getEnvironment();
        System system = deployment.getComponentVersion().getComponent().getSystem();
        String systemPageId = this.generateSystemPage(rootPageId, system);
        String deploymentListParentPageId = this.generateDeploymentHistoryPageForEnvironment(systemPageId, environment, system);
        int year = deployment.getStartedAt().getYear();
        String deploymentLetterParentPageId = this.generateDeploymentListPage(deploymentListParentPageId, environment, system, year);
        this.generateDeploymentHistoryOverviewPageForEnvironment(rootPageId, environment);
        if (deployment.getSequence() != DeploymentSequence.UNDEPLOYED) {
            return this.generateDeploymentLetter(deploymentLetterParentPageId, deployment);
        }
        return this.generateUndeploymentLetter(deploymentLetterParentPageId, deployment);
    }

    @Transactional
    public void migrateSystem(System system) {
        log.info("Retrieve the deployments for the system '{}'", (Object)system.getName());
        List deployments = this.deploymentPageRepository.getDeploymentPagesForSystem(system.getId());
        String rootPageId = this.confluenceAdapter.getPageByName(this.props.getDeploymentsPageName());
        Optional existingSystemPage = this.systemPageRepository.findSystemPageBySystemId(system.getId());
        String existingSystemPageId = null;
        if (existingSystemPage.isPresent()) {
            existingSystemPageId = ((SystemPage)existingSystemPage.get()).getSystemPageId();
        }
        log.info("Generating pages of system '{}'", (Object)system.getName());
        String systemPageId = this.generateSystemPage(rootPageId, system);
        log.info("Moving {} deployment pages of system '{}'", (Object)deployments.size(), (Object)system.getName());
        this.moveDeploymentPages(system, systemPageId, deployments);
        Iterable environmentList = this.environmentRepository.findAll();
        environmentList.forEach(environment -> this.generateDeploymentHistoryOverviewPageForEnvironment(rootPageId, (Environment)environment));
        if (existingSystemPageId != null) {
            log.info("Deleting old system page with id '{}' and all child pages", (Object)existingSystemPageId);
            this.confluenceAdapter.deletePageAndChildPages(existingSystemPageId);
        }
    }

    @Transactional
    public void mergeSystems(System system, System oldSystem) {
        log.info("Retrieve the deployments for the system '{}' to merge into '{}'", (Object)oldSystem.getName(), (Object)system.getName());
        List deployments = this.deploymentPageRepository.getDeploymentPagesForSystem(oldSystem.getId());
        String rootPageId = this.confluenceAdapter.getPageByName(this.props.getDeploymentsPageName());
        SystemPage existingSystemPage = (SystemPage)this.systemPageRepository.findSystemPageBySystemId(system.getId()).orElseThrow(() -> new IllegalStateException("SystemPage for " + system.getName() + " not found"));
        log.info("Moving {} deployment pages of system '{}' to system '{}'", new Object[]{deployments.size(), oldSystem.getName(), system.getName()});
        this.moveDeploymentPages(system, existingSystemPage.getSystemPageId(), deployments);
        Iterable environmentList = this.environmentRepository.findAll();
        environmentList.forEach(environment -> this.generateDeploymentHistoryOverviewPageForEnvironment(rootPageId, (Environment)environment));
        Optional existingOldSystemPage = this.systemPageRepository.findSystemPageBySystemId(oldSystem.getId());
        if (existingOldSystemPage.isPresent()) {
            String existingOldSystemPageId = ((SystemPage)existingOldSystemPage.get()).getSystemPageId();
            log.info("Deleting old system page with id '{}' and all child pages", (Object)existingOldSystemPageId);
            this.confluenceAdapter.deletePageAndChildPages(existingOldSystemPageId);
            this.systemPageRepository.deleteSystemPage((SystemPage)existingOldSystemPage.get());
        }
        this.environmentHistoryPageRepository.deleteEnvironmentHistoryPageBySystemId(oldSystem.getId());
        this.deploymentListPageRepository.deleteDeploymentListPageBySystemId(oldSystem.getId());
    }

    private void moveDeploymentPages(System system, String systemPageId, List<DeploymentPageQueryResult> deployments) {
        HashMap<Environment, String> environmentPagesByEnvironment = new HashMap<Environment, String>();
        HashMap<CallSite, String> environmentPagesByEnvironmentAndYear = new HashMap<CallSite, String>();
        for (DeploymentPageQueryResult deploymentInfo : deployments) {
            String deploymentLetterParentPageId;
            String deploymentListParentPageId;
            Deployment deployment = this.deploymentRepository.getById(deploymentInfo.id());
            Environment environment = deployment.getEnvironment();
            if (environmentPagesByEnvironment.containsKey(environment)) {
                deploymentListParentPageId = (String)environmentPagesByEnvironment.get(environment);
            } else {
                deploymentListParentPageId = this.generateDeploymentHistoryPageForEnvironment(systemPageId, environment, system);
                environmentPagesByEnvironment.put(environment, deploymentListParentPageId);
            }
            int year = deployment.getStartedAt().getYear();
            if (environmentPagesByEnvironmentAndYear.containsKey(environment.getName() + year)) {
                deploymentLetterParentPageId = (String)environmentPagesByEnvironmentAndYear.get(environment.getName() + year);
            } else {
                deploymentLetterParentPageId = this.generateDeploymentListPage(deploymentListParentPageId, environment, system, year);
                environmentPagesByEnvironmentAndYear.put((CallSite)((Object)(environment.getName() + year)), deploymentLetterParentPageId);
            }
            this.confluenceAdapter.movePage(deploymentLetterParentPageId, deploymentInfo.pageId());
        }
    }

    private String generateSystemPage(String rootPageId, System system) {
        String content = this.templateRenderer.renderSystemPage(this.generatorService.createSystemPageDto(system));
        String pageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(rootPageId, system.getName(), content);
        this.generatorService.persistSystemPage(system, pageId);
        return pageId;
    }

    private String generateDeploymentHistoryPageForEnvironment(String systemPageId, Environment environment, System system) {
        List<DeploymentDto> deploymentDtoList = this.generatorService.getDeploymentsForSystemAndEnv(system, environment, this.props.getDeploymentHistoryMaxShow());
        DeploymentHistoryPageDto deploymentHistoryPageDto = DeploymentHistoryPageDto.builder().systemName(system.getName()).environmentName(environment.getName()).deployments(deploymentDtoList).deploymentHistoryMaxShow(this.props.getDeploymentHistoryMaxShow()).build();
        String content = this.templateRenderer.renderDeploymentHistoryPage(deploymentHistoryPageDto);
        String pageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(systemPageId, deploymentHistoryPageDto.getPageTitle(), content);
        this.generatorService.persistDeploymentHistoryPage(system, environment, pageId);
        return pageId;
    }

    private void generateDeploymentHistoryOverviewPageForEnvironment(String rootPageId, Environment environment) {
        ZonedDateTime minStartedAt = ZonedDateTime.now().minus(this.props.getDeploymentHistoryOverviewMaxTime());
        String deploymentOverviewPageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(rootPageId, "_Deployment History Overview", this.templateRenderer.renderDeploymentHistoryOverviewRootPage());
        List<DeploymentDto> deploymentDtoList = this.generatorService.getDeploymentsForEnv(environment, minStartedAt, this.props.getDeploymentHistoryMaxShow());
        DeploymentHistoryOverviewPageDto deploymentHistoryOverviewPageDto = DeploymentHistoryOverviewPageDto.builder().environmentName(environment.getName()).deployments(deploymentDtoList).deploymentHistoryMaxShow(this.props.getDeploymentHistoryMaxShow()).deploymentHistoryOverviewMinStartedAt(minStartedAt.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"))).build();
        String content = this.templateRenderer.renderDeploymentHistoryOverviewPage(deploymentHistoryOverviewPageDto);
        this.confluenceAdapter.addOrUpdatePageUnderAncestor(deploymentOverviewPageId, deploymentHistoryOverviewPageDto.getPageTitle(), content);
    }

    private String generateDeploymentListPage(String parentPageId, Environment environment, System system, int year) {
        DeploymentListPageDto deploymentListPageDto = new DeploymentListPageDto(environment.getName(), system.getName(), year);
        String content = this.templateRenderer.renderDeploymentListPage();
        String pageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(parentPageId, deploymentListPageDto.getPageTitle(), content);
        this.generatorService.persistDeploymentListPage(system, environment, pageId, year);
        return pageId;
    }

    @Transactional
    public void generateAllPages() {
        String rootPageId = this.confluenceAdapter.getPageByName(this.props.getDeploymentsPageName());
        List systemList = this.systemRepository.findAll();
        systemList.forEach(system -> this.recursivelyGenerateSystemPage(rootPageId, (System)system, null));
        Iterable environmentList = this.environmentRepository.findAll();
        environmentList.forEach(environment -> this.generateDeploymentHistoryOverviewPageForEnvironment(rootPageId, (Environment)environment));
    }

    @Transactional
    public void generateAllPagesForSystem(String systemName, Integer year) {
        String rootPageId = this.confluenceAdapter.getPageByName(this.props.getDeploymentsPageName());
        System system = (System)this.systemRepository.findByNameIgnoreCase(systemName).orElseThrow();
        this.recursivelyGenerateSystemPage(rootPageId, system, year);
        Iterable environmentList = this.environmentRepository.findAll();
        environmentList.forEach(environment -> this.generateDeploymentHistoryOverviewPageForEnvironment(rootPageId, (Environment)environment));
    }

    @Transactional(readOnly=true)
    public void generateJiraLinksForSystem(String systemName, ZonedDateTime from, ZonedDateTime to) {
        System system = (System)this.systemRepository.findByNameIgnoreCase(systemName).orElseThrow();
        List deployments = this.deploymentRepository.findAllDeploymentsForSystemStartedBetween(system, from, to);
        log.info("Found {} deployments for system '{}' between {} and {}", new Object[]{deployments.size(), systemName, from, to});
        for (Deployment deployment : deployments) {
            Set jiraIssueKeys;
            if (deployment.getChangelog() == null || (jiraIssueKeys = deployment.getChangelog().getJiraIssueKeys()) == null || jiraIssueKeys.isEmpty()) continue;
            this.deploymentPageRepository.findDeploymentPageByDeploymentId(deployment.getId()).ifPresent(deploymentPage -> this.jiraAdapter.updateJiraIssuesWithConfluenceLink(jiraIssueKeys, deploymentPage.getPageId()));
        }
    }

    private void recursivelyGenerateSystemPage(String rootPageId, System system, Integer year) {
        String systemPageId = this.generateSystemPage(rootPageId, system);
        this.recursivelyGenerateDeploymentHistory(systemPageId, system, year);
    }

    private void recursivelyGenerateDeploymentHistory(String systemPageId, System system, Integer year) {
        List<Environment> environmentList = this.generatorService.getEnvironmentsForSystem(system);
        environmentList.forEach(environment -> this.recursivelyGenerateDeploymentHistoryPageForEnvironment(systemPageId, (Environment)environment, system, year));
    }

    private void recursivelyGenerateDeploymentHistoryPageForEnvironment(String systemPageId, Environment environment, System system, Integer year) {
        String pageId = this.generateDeploymentHistoryPageForEnvironment(systemPageId, environment, system);
        List<Integer> yearList = this.generatorService.getDeploymentsYearsForSystemAndEnv(system, environment);
        if (year != null) {
            yearList = yearList.stream().filter(y -> y.equals(year)).toList();
        }
        yearList.forEach(currentYear -> this.recursivelyGenerateDeploymentListPage(pageId, environment, system, (int)currentYear));
    }

    private void recursivelyGenerateDeploymentListPage(String parentPageId, Environment environment, System system, int year) {
        String pageId = this.generateDeploymentListPage(parentPageId, environment, system, year);
        List<DeploymentLetterPageDto> deploymentLetterPageDtoList = this.generatorService.getDeploymentsForYearForSystemAndEnv(year, system, environment);
        for (DeploymentLetterPageDto deploymentLetterPageDto : deploymentLetterPageDtoList) {
            if (DeploymentSequence.UNDEPLOYED.getLabel().equals(deploymentLetterPageDto.getSequence())) {
                this.generateUndeploymentLetter(pageId, deploymentLetterPageDto);
                continue;
            }
            this.generateDeploymentLetter(pageId, deploymentLetterPageDto);
        }
    }

    private GeneratedDeploymentPageDto generateDeploymentLetter(String parentPageId, Deployment deployment) {
        DeploymentLetterPageDto deploymentLetterPageDto = this.generatorService.createDeploymentLetterPageDto(deployment);
        return this.generateDeploymentLetter(parentPageId, deploymentLetterPageDto);
    }

    private GeneratedDeploymentPageDto generateDeploymentLetter(String parentPageId, DeploymentLetterPageDto deploymentLetterPageDto) {
        String content = this.templateRenderer.renderDeploymentLetterPage(deploymentLetterPageDto);
        String pageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(parentPageId, deploymentLetterPageDto.getPageTitle(), content);
        this.generatorService.persistDeploymentPage(UUID.fromString(deploymentLetterPageDto.getDeploymentId()), pageId, deploymentLetterPageDto.getDeploymentStateTimestamp());
        return GeneratedDeploymentPageDto.builder().deploymentLetterPageDto(deploymentLetterPageDto).pageId(pageId).build();
    }

    private GeneratedDeploymentPageDto generateUndeploymentLetter(String parentPageId, DeploymentLetterPageDto deploymentLetterPageDto) {
        String content = this.templateRenderer.renderUndeploymentLetterPage(deploymentLetterPageDto);
        String pageId = this.confluenceAdapter.addOrUpdatePageUnderAncestor(parentPageId, deploymentLetterPageDto.getPageTitle(), content);
        this.generatorService.persistDeploymentPage(UUID.fromString(deploymentLetterPageDto.getDeploymentId()), pageId, deploymentLetterPageDto.getDeploymentStateTimestamp());
        return GeneratedDeploymentPageDto.builder().deploymentLetterPageDto(deploymentLetterPageDto).pageId(pageId).build();
    }

    @Timed(value="update_deployment_history_pages")
    @Transactional
    public void updateDeploymentHistoryPages(Collection<SystemEnv> envsBySystems) {
        for (SystemEnv systemEnv : envsBySystems) {
            System system = this.systemRepository.getById(systemEnv.getSystemId());
            Environment env = this.environmentRepository.getById(systemEnv.getEnvId());
            Optional systemPage = this.systemPageRepository.findSystemPageBySystemId(systemEnv.getSystemId());
            if (!systemPage.isPresent()) continue;
            String systemPageId = ((SystemPage)systemPage.get()).getSystemPageId();
            this.generateDeploymentHistoryPageForEnvironment(systemPageId, env, system);
        }
    }

    private GeneratedDeploymentPageDto generateUndeploymentLetter(String parentPageId, Deployment deployment) {
        DeploymentLetterPageDto undeploymentLetterPageDto = this.generatorService.createUndeploymentLetterPageDto(deployment);
        return this.generateUndeploymentLetter(parentPageId, undeploymentLetterPageDto);
    }

    @Generated
    public DocumentationGenerator(ConfluenceAdapter confluenceAdapter, JiraAdapter jiraAdapter, TemplateRenderer templateRenderer, DocumentationGeneratorConfluenceProperties props, SystemRepository systemRepository, EnvironmentRepository environmentRepository, GeneratorService generatorService, DeploymentRepository deploymentRepository, DeploymentPageRepository deploymentPageRepository, SystemPageRepository systemPageRepository, EnvironmentHistoryPageRepository environmentHistoryPageRepository, DeploymentListPageRepository deploymentListPageRepository) {
        this.confluenceAdapter = confluenceAdapter;
        this.jiraAdapter = jiraAdapter;
        this.templateRenderer = templateRenderer;
        this.props = props;
        this.systemRepository = systemRepository;
        this.environmentRepository = environmentRepository;
        this.generatorService = generatorService;
        this.deploymentRepository = deploymentRepository;
        this.deploymentPageRepository = deploymentPageRepository;
        this.systemPageRepository = systemPageRepository;
        this.environmentHistoryPageRepository = environmentHistoryPageRepository;
        this.deploymentListPageRepository = deploymentListPageRepository;
    }
}

