/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen.service;

import ch.admin.bit.jeap.deploymentlog.docgen.DocumentationGenerator;
import ch.admin.bit.jeap.deploymentlog.docgen.JiraAdapter;
import ch.admin.bit.jeap.deploymentlog.docgen.model.GeneratedDeploymentPageDto;
import ch.admin.bit.jeap.deploymentlog.docgen.service.DocgenLocks;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.System;
import ch.admin.bit.jeap.deploymentlog.domain.SystemEnv;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DocgenAsyncService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocgenAsyncService.class);
    private final DocumentationGenerator documentationGenerator;
    private final DeploymentRepository deploymentRepository;
    private final Counter errorCounter;
    private final DocgenLocks locks;
    private final JiraAdapter jiraAdapter;

    public DocgenAsyncService(DocumentationGenerator documentationGenerator, DeploymentRepository deploymentRepository, MeterRegistry meterRegistry, DocgenLocks locks, JiraAdapter jiraAdapter) {
        this.documentationGenerator = documentationGenerator;
        this.deploymentRepository = deploymentRepository;
        this.locks = locks;
        this.errorCounter = meterRegistry.counter("deploymentlog.docgen.deploymentpages.error", new String[0]);
        this.jiraAdapter = jiraAdapter;
    }

    @Async(value="asyncThreadpoolDocgenExecutor")
    public void triggerDocgenForUndeployment(String systemName, UUID deploymentId) {
        this.locks.runIfLockAquiredBeforeTimeout(systemName, () -> this.generateDeploymentPages(deploymentId));
    }

    @Async(value="asyncThreadpoolDocgenExecutor")
    public void triggerDocgenForDeployment(UUID deploymentId) {
        String systemName = this.deploymentRepository.getSystemNameForDeployment(deploymentId);
        this.locks.runIfLockAquiredBeforeTimeout(systemName, () -> this.generateDeploymentPages(deploymentId));
    }

    @Async(value="asyncThreadpoolDocgenExecutor")
    public void triggerDocgenForSystem(String systemName, Integer year) {
        this.locks.runIfLockAquiredBeforeTimeout(systemName, () -> this.documentationGenerator.generateAllPagesForSystem(systemName, year));
    }

    @Async(value="asyncThreadpoolDocgenExecutor")
    public void triggerGenerateJiraLinksForSystem(String systemName, ZonedDateTime from, ZonedDateTime to) {
        this.documentationGenerator.generateJiraLinksForSystem(systemName, from, to);
    }

    private void generateDeploymentPages(UUID deploymentId) {
        try {
            GeneratedDeploymentPageDto generatedDeploymentPageDto = this.documentationGenerator.generateDeploymentPages(deploymentId);
            Set<String> jiraIssueKeys = generatedDeploymentPageDto.getDeploymentLetterPageDto().getChangeJiraIssueKeys();
            if (jiraIssueKeys != null && !jiraIssueKeys.isEmpty()) {
                this.jiraAdapter.updateJiraIssuesWithConfluenceLink(generatedDeploymentPageDto);
            }
        }
        catch (Exception ex) {
            this.errorCounter.increment();
            log.warn("Failed to generate pages for deployment {}", (Object)StructuredArguments.value((String)"deploymentId", (Object)deploymentId), (Object)ex);
        }
    }

    @Async(value="asyncThreadpoolDocgenExecutor")
    public void triggerMigrationForSystem(System system) {
        this.locks.runIfLockAquiredBeforeTimeout(system.getName(), () -> this.migrateSystem(system));
    }

    private void migrateSystem(System system) {
        try {
            this.documentationGenerator.migrateSystem(system);
        }
        catch (Exception ex) {
            this.errorCounter.increment();
            log.warn("Failed to generate pages for system {}", (Object)StructuredArguments.value((String)"systemName", (Object)system.getName()), (Object)ex);
        }
    }

    @Async(value="asyncThreadpoolDocgenExecutor")
    public void triggerMergeSystems(System system, System oldSystem) {
        this.locks.runIfLockAquiredBeforeTimeout(system.getName(), () -> this.mergeSystems(system, oldSystem));
    }

    private void mergeSystems(System system, System oldSystem) {
        try {
            this.documentationGenerator.mergeSystems(system, oldSystem);
        }
        catch (Exception ex) {
            this.errorCounter.increment();
            log.warn("Failed to generate pages for system {}", (Object)StructuredArguments.value((String)"systemName", (Object)system.getName()), (Object)ex);
        }
    }

    @Async(value="asyncThreadpoolDocgenExecutor")
    public void triggerUpdateDeploymentListPages(Collection<SystemEnv> envsBySystems) {
        envsBySystems.stream().collect(Collectors.groupingBy(SystemEnv::getSystemName)).forEach((systemName, systemEnvs) -> this.locks.runIfLockAquiredBeforeTimeout((String)systemName, () -> this.documentationGenerator.updateDeploymentHistoryPages((Collection<SystemEnv>)systemEnvs)));
    }
}

