/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.docgen.service;

import ch.admin.bit.jeap.deploymentlog.docgen.ConfluenceAdapter;
import ch.admin.bit.jeap.deploymentlog.docgen.service.DocgenAsyncService;
import ch.admin.bit.jeap.deploymentlog.docgen.service.SchedulingConfigProperties;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPage;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentService;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import net.javacrumbs.shedlock.core.LockAssert;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SchedulingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulingService.class);
    private static final int GENERATOR_LAG_MAX_AGE_DAYS = 7;
    private final DeploymentService deploymentService;
    private final DocgenAsyncService docgenAsyncService;
    private final ConfluenceAdapter confluenceAdapter;
    private final DeploymentPageRepository pageRepository;
    private final SchedulingConfigProperties configProperties;
    private final MeterRegistry meterRegistry;
    private AtomicLong deploymentPageGenerationLagCounter;

    @Scheduled(cron="${jeap.deploymentlog.documentation-generator.scheduled.cron:'-'}")
    @SchedulerLock(name="generate-missing-pages", lockAtLeastFor="60s", lockAtMostFor="5m")
    public void generateMissingPages() {
        LockAssert.assertLocked();
        log.debug("Checking for missing pages that need to be generated...");
        List deploymentIds = this.deploymentService.getMissingDeploymentPages(this.configProperties.getRetriedPagesLimit(), this.configProperties.getMinAgeMinutes(), this.configProperties.getMaxAgeMinutes());
        if (!deploymentIds.isEmpty()) {
            log.warn("Re-generating {} pages: {}", (Object)deploymentIds.size(), (Object)deploymentIds);
        }
        deploymentIds.forEach(this.docgenAsyncService::triggerDocgenForDeployment);
        log.debug("Missing page check finished");
    }

    @Scheduled(cron="${jeap.deploymentlog.documentation-generator.housekeeping.cron:'-'}")
    @SchedulerLock(name="outdated-page-housekeeping", lockAtLeastFor="60s", lockAtMostFor="30m")
    public void outdatedPageHousekeeping() {
        LockAssert.assertLocked();
        Duration minAge = Duration.ofDays(7L);
        log.debug("Checking for {} old pages that need to be deleted...", (Object)minAge);
        List outdatedPages = this.deploymentService.getOutdatedNonProductiveDeploymentPages(minAge, this.configProperties.getKeepDeploymentPagePerEnvCount());
        outdatedPages.forEach(this::deletePage);
        Set<UUID> deletedPageDeploymentIds = outdatedPages.stream().map(DeploymentPage::getDeploymentId).collect(Collectors.toSet());
        this.updateDeploymentListPages(deletedPageDeploymentIds);
        log.debug("Old page check finished");
    }

    private void updateDeploymentListPages(Set<UUID> deploymentIds) {
        Set systemEnvs = this.deploymentService.getSystemAndEnvsForDeploymentIds(deploymentIds);
        this.docgenAsyncService.triggerUpdateDeploymentListPages(systemEnvs);
    }

    private void deletePage(DeploymentPage deploymentPage) {
        try {
            log.info("Deleting outdated deployment page {}", (Object)deploymentPage);
            this.confluenceAdapter.deletePage(deploymentPage.getPageId());
            this.pageRepository.delete(deploymentPage);
        }
        catch (Exception ex) {
            log.error("Failed to delete page {}", (Object)deploymentPage, (Object)ex);
        }
    }

    @PostConstruct
    @Scheduled(fixedRate=15L, timeUnit=TimeUnit.MINUTES)
    public void updateMetrics() {
        long deploymentPageGenerationLag = this.deploymentService.countMissingDeploymentPages(7);
        if (this.deploymentPageGenerationLagCounter == null) {
            this.deploymentPageGenerationLagCounter = (AtomicLong)this.meterRegistry.gauge("deploymentlog.docgen.deploymentpages.lag", (Number)new AtomicLong(deploymentPageGenerationLag));
        }
        this.deploymentPageGenerationLagCounter.set(deploymentPageGenerationLag);
    }

    @Generated
    public SchedulingService(DeploymentService deploymentService, DocgenAsyncService docgenAsyncService, ConfluenceAdapter confluenceAdapter, DeploymentPageRepository pageRepository, SchedulingConfigProperties configProperties, MeterRegistry meterRegistry) {
        this.deploymentService = deploymentService;
        this.docgenAsyncService = docgenAsyncService;
        this.confluenceAdapter = confluenceAdapter;
        this.pageRepository = pageRepository;
        this.configProperties = configProperties;
        this.meterRegistry = meterRegistry;
    }
}

