/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="ENVIRONMENT_NAME_UK", columnNames={"name"})})
public class Environment {
    @Id
    private UUID id;
    @NonNull
    private String name;
    private int stagingOrder;
    private boolean productive;
    private boolean development;

    public Environment(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.name = name;
        this.development = name.equalsIgnoreCase("DEV");
        this.productive = name.equalsIgnoreCase("PROD");
        this.stagingOrder = this.productive ? Integer.MAX_VALUE : 0;
    }

    @Generated
    private Environment(UUID id, @NonNull String name, int stagingOrder, boolean productive, boolean development) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.stagingOrder = stagingOrder;
        this.productive = productive;
        this.development = development;
    }

    @Generated
    protected Environment() {
    }

    @Generated
    public String toString() {
        return "Environment(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", stagingOrder=" + this.getStagingOrder() + ", productive=" + this.isProductive() + ", development=" + this.isDevelopment() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getStagingOrder() {
        return this.stagingOrder;
    }

    @Generated
    public boolean isProductive() {
        return this.productive;
    }

    @Generated
    public boolean isDevelopment() {
        return this.development;
    }

    @Generated
    public void setStagingOrder(int stagingOrder) {
        this.stagingOrder = stagingOrder;
    }

    @Generated
    public void setProductive(boolean productive) {
        this.productive = productive;
    }

    @Generated
    public void setDevelopment(boolean development) {
        this.development = development;
    }
}

