/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import ch.admin.bit.jeap.deploymentlog.domain.Changelog;
import ch.admin.bit.jeap.deploymentlog.domain.ComponentVersion;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentSequence;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentState;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentTarget;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.Link;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="DEPLOYMENT_EXTERNAL_ID_UK", columnNames={"externalId"})})
public class Deployment {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Deployment.class);
    @Id
    private UUID id;
    @NonNull
    private String externalId;
    @NonNull
    private ZonedDateTime startedAt;
    private ZonedDateTime endedAt;
    @NonNull
    private ZonedDateTime lastModified;
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private DeploymentState state;
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private DeploymentSequence sequence;
    private String stateMessage;
    @NonNull
    private String startedBy;
    @ManyToOne(fetch=FetchType.LAZY)
    @NonNull
    private Environment environment;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @NonNull
    private ComponentVersion componentVersion;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Changelog changelog;
    @ElementCollection(fetch=FetchType.LAZY)
    private Set<Link> links;
    private String remedyChangeId;
    @ElementCollection
    @CollectionTable(name="deployment_properties", joinColumns={@JoinColumn(name="deployment_id")})
    @MapKeyColumn(name="property_name")
    @Column(name="property_value")
    private Map<String, String> properties = new HashMap<String, String>();
    @ElementCollection
    @CollectionTable(name="deployment_references", joinColumns={@JoinColumn(name="deployment_id")})
    @Column(name="reference_identifier")
    @Enumerated(value=EnumType.STRING)
    private Set<String> referenceIdentifiers = new HashSet<String>();
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="type", column=@Column(name="target_type")), @AttributeOverride(name="url", column=@Column(name="target_url")), @AttributeOverride(name="details", column=@Column(name="target_details"))})
    private DeploymentTarget target;

    private Deployment(@NonNull String externalId, @NonNull ZonedDateTime startedAt, @NonNull String startedBy, @NonNull Environment environment, DeploymentTarget target, @NonNull ComponentVersion componentVersion, Set<Link> links, Map<String, String> properties, Set<String> referenceIdentifiers, Changelog changelog, @NonNull DeploymentSequence sequence, String remedyChangeId) {
        if (externalId == null) {
            throw new NullPointerException("externalId is marked non-null but is null");
        }
        if (startedAt == null) {
            throw new NullPointerException("startedAt is marked non-null but is null");
        }
        if (startedBy == null) {
            throw new NullPointerException("startedBy is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (componentVersion == null) {
            throw new NullPointerException("componentVersion is marked non-null but is null");
        }
        if (sequence == null) {
            throw new NullPointerException("sequence is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.state = DeploymentState.STARTED;
        this.externalId = externalId;
        this.startedAt = startedAt;
        this.lastModified = ZonedDateTime.now();
        this.startedBy = startedBy;
        this.environment = environment;
        this.target = target;
        this.componentVersion = componentVersion;
        this.links = links;
        this.properties = new HashMap<String, String>(properties == null ? Map.of() : properties);
        this.referenceIdentifiers = new HashSet<String>(referenceIdentifiers == null ? Set.of() : referenceIdentifiers);
        this.changelog = changelog;
        this.sequence = sequence;
        this.remedyChangeId = remedyChangeId;
    }

    public void failed(ZonedDateTime endedAt, String stateMessage) {
        this.endedAt = endedAt;
        this.lastModified = ZonedDateTime.now();
        this.state = DeploymentState.FAILURE;
        this.stateMessage = StringUtils.abbreviate((String)stateMessage, (int)1000);
    }

    public void success(ZonedDateTime endedAt, String stateMessage) {
        this.endedAt = endedAt;
        this.lastModified = ZonedDateTime.now();
        this.state = DeploymentState.SUCCESS;
        this.stateMessage = StringUtils.abbreviate((String)stateMessage, (int)1000);
    }

    @Generated
    public static DeploymentBuilder builder() {
        return new DeploymentBuilder();
    }

    @Generated
    protected Deployment() {
    }

    @Generated
    public String toString() {
        return "Deployment(id=" + String.valueOf(this.getId()) + ", externalId=" + this.getExternalId() + ", startedAt=" + String.valueOf(this.getStartedAt()) + ", endedAt=" + String.valueOf(this.getEndedAt()) + ", lastModified=" + String.valueOf(this.getLastModified()) + ", state=" + String.valueOf((Object)this.getState()) + ", sequence=" + String.valueOf((Object)this.getSequence()) + ", stateMessage=" + this.getStateMessage() + ", startedBy=" + this.getStartedBy() + ", componentVersion=" + String.valueOf(this.getComponentVersion()) + ", changelog=" + String.valueOf(this.getChangelog()) + ", links=" + String.valueOf(this.getLinks()) + ", remedyChangeId=" + this.getRemedyChangeId() + ", properties=" + String.valueOf(this.getProperties()) + ", referenceIdentifiers=" + String.valueOf(this.getReferenceIdentifiers()) + ", target=" + String.valueOf(this.getTarget()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @NonNull
    @Generated
    public ZonedDateTime getStartedAt() {
        return this.startedAt;
    }

    @Generated
    public ZonedDateTime getEndedAt() {
        return this.endedAt;
    }

    @NonNull
    @Generated
    public ZonedDateTime getLastModified() {
        return this.lastModified;
    }

    @NonNull
    @Generated
    public DeploymentState getState() {
        return this.state;
    }

    @NonNull
    @Generated
    public DeploymentSequence getSequence() {
        return this.sequence;
    }

    @Generated
    public String getStateMessage() {
        return this.stateMessage;
    }

    @NonNull
    @Generated
    public String getStartedBy() {
        return this.startedBy;
    }

    @NonNull
    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @NonNull
    @Generated
    public ComponentVersion getComponentVersion() {
        return this.componentVersion;
    }

    @Generated
    public Changelog getChangelog() {
        return this.changelog;
    }

    @Generated
    public Set<Link> getLinks() {
        return this.links;
    }

    @Generated
    public String getRemedyChangeId() {
        return this.remedyChangeId;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public Set<String> getReferenceIdentifiers() {
        return this.referenceIdentifiers;
    }

    @Generated
    public DeploymentTarget getTarget() {
        return this.target;
    }

    @Generated
    public static class DeploymentBuilder {
        @Generated
        private String externalId;
        @Generated
        private ZonedDateTime startedAt;
        @Generated
        private String startedBy;
        @Generated
        private Environment environment;
        @Generated
        private DeploymentTarget target;
        @Generated
        private ComponentVersion componentVersion;
        @Generated
        private Set<Link> links;
        @Generated
        private Map<String, String> properties;
        @Generated
        private Set<String> referenceIdentifiers;
        @Generated
        private Changelog changelog;
        @Generated
        private DeploymentSequence sequence;
        @Generated
        private String remedyChangeId;

        @Generated
        DeploymentBuilder() {
        }

        @Generated
        public DeploymentBuilder externalId(@NonNull String externalId) {
            if (externalId == null) {
                throw new NullPointerException("externalId is marked non-null but is null");
            }
            this.externalId = externalId;
            return this;
        }

        @Generated
        public DeploymentBuilder startedAt(@NonNull ZonedDateTime startedAt) {
            if (startedAt == null) {
                throw new NullPointerException("startedAt is marked non-null but is null");
            }
            this.startedAt = startedAt;
            return this;
        }

        @Generated
        public DeploymentBuilder startedBy(@NonNull String startedBy) {
            if (startedBy == null) {
                throw new NullPointerException("startedBy is marked non-null but is null");
            }
            this.startedBy = startedBy;
            return this;
        }

        @Generated
        public DeploymentBuilder environment(@NonNull Environment environment) {
            if (environment == null) {
                throw new NullPointerException("environment is marked non-null but is null");
            }
            this.environment = environment;
            return this;
        }

        @Generated
        public DeploymentBuilder target(DeploymentTarget target) {
            this.target = target;
            return this;
        }

        @Generated
        public DeploymentBuilder componentVersion(@NonNull ComponentVersion componentVersion) {
            if (componentVersion == null) {
                throw new NullPointerException("componentVersion is marked non-null but is null");
            }
            this.componentVersion = componentVersion;
            return this;
        }

        @Generated
        public DeploymentBuilder links(Set<Link> links) {
            this.links = links;
            return this;
        }

        @Generated
        public DeploymentBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public DeploymentBuilder referenceIdentifiers(Set<String> referenceIdentifiers) {
            this.referenceIdentifiers = referenceIdentifiers;
            return this;
        }

        @Generated
        public DeploymentBuilder changelog(Changelog changelog) {
            this.changelog = changelog;
            return this;
        }

        @Generated
        public DeploymentBuilder sequence(@NonNull DeploymentSequence sequence) {
            if (sequence == null) {
                throw new NullPointerException("sequence is marked non-null but is null");
            }
            this.sequence = sequence;
            return this;
        }

        @Generated
        public DeploymentBuilder remedyChangeId(String remedyChangeId) {
            this.remedyChangeId = remedyChangeId;
            return this;
        }

        @Generated
        public Deployment build() {
            return new Deployment(this.externalId, this.startedAt, this.startedBy, this.environment, this.target, this.componentVersion, this.links, this.properties, this.referenceIdentifiers, this.changelog, this.sequence, this.remedyChangeId);
        }

        @Generated
        public String toString() {
            return "Deployment.DeploymentBuilder(externalId=" + this.externalId + ", startedAt=" + String.valueOf(this.startedAt) + ", startedBy=" + this.startedBy + ", environment=" + String.valueOf(this.environment) + ", target=" + String.valueOf(this.target) + ", componentVersion=" + String.valueOf(this.componentVersion) + ", links=" + String.valueOf(this.links) + ", properties=" + String.valueOf(this.properties) + ", referenceIdentifiers=" + String.valueOf(this.referenceIdentifiers) + ", changelog=" + String.valueOf(this.changelog) + ", sequence=" + String.valueOf((Object)this.sequence) + ", remedyChangeId=" + this.remedyChangeId + ")";
        }
    }
}

