/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.ComponentVersion;
import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class EnvironmentComponentVersionState {
    @Id
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @NonNull
    private Environment environment;
    @ManyToOne(fetch=FetchType.LAZY)
    @NonNull
    private Component component;
    @ManyToOne(fetch=FetchType.LAZY)
    @NonNull
    private ComponentVersion componentVersion;
    @ManyToOne(fetch=FetchType.LAZY)
    @NonNull
    private Deployment deployment;

    private EnvironmentComponentVersionState(@NonNull Environment environment, @NonNull Component component, @NonNull ComponentVersion componentVersion, @NonNull Deployment deployment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (componentVersion == null) {
            throw new NullPointerException("componentVersion is marked non-null but is null");
        }
        if (deployment == null) {
            throw new NullPointerException("deployment is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.environment = environment;
        this.component = component;
        this.componentVersion = componentVersion;
        this.deployment = deployment;
    }

    public static EnvironmentComponentVersionState fromDeployment(Deployment deployment) {
        return new EnvironmentComponentVersionState(deployment.getEnvironment(), deployment.getComponentVersion().getComponent(), deployment.getComponentVersion(), deployment);
    }

    public void updateVersion(ComponentVersion componentVersion, Deployment deployment) {
        this.componentVersion = componentVersion;
        this.deployment = deployment;
    }

    public String toString() {
        return "EnvironmentComponentVersionState{environment=" + this.environment.getName() + "component=" + this.component.getName() + "componentVersion=" + this.componentVersion.getVersionName() + "startedAt=" + String.valueOf(this.deployment.getStartedAt()) + "deployedAt=" + String.valueOf(this.deployment.getEndedAt()) + "}";
    }

    @Generated
    protected EnvironmentComponentVersionState() {
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @NonNull
    @Generated
    public Component getComponent() {
        return this.component;
    }

    @NonNull
    @Generated
    public ComponentVersion getComponentVersion() {
        return this.componentVersion;
    }

    @NonNull
    @Generated
    public Deployment getDeployment() {
        return this.deployment;
    }
}

