/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

@Entity
public class Changelog {
    @Id
    private UUID id;
    private String comment;
    private String comparedToVersion;
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="changelog_jira_issue", joinColumns={@JoinColumn(name="changelog")})
    @Column(name="issue_key")
    private Set<String> jiraIssueKeys;

    private Changelog(String comment, String comparedToVersion, @NonNull Set<String> jiraIssueKeys) {
        if (jiraIssueKeys == null) {
            throw new NullPointerException("jiraIssueKeys is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.comment = comment == null ? null : StringUtils.abbreviate((String)comment, (int)250);
        this.comparedToVersion = comparedToVersion;
        this.jiraIssueKeys = new HashSet<String>(jiraIssueKeys);
    }

    @Generated
    public static ChangelogBuilder builder() {
        return new ChangelogBuilder();
    }

    @Generated
    protected Changelog() {
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getComparedToVersion() {
        return this.comparedToVersion;
    }

    @Generated
    public Set<String> getJiraIssueKeys() {
        return this.jiraIssueKeys;
    }

    @Generated
    public static class ChangelogBuilder {
        @Generated
        private String comment;
        @Generated
        private String comparedToVersion;
        @Generated
        private Set<String> jiraIssueKeys;

        @Generated
        ChangelogBuilder() {
        }

        @Generated
        public ChangelogBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public ChangelogBuilder comparedToVersion(String comparedToVersion) {
            this.comparedToVersion = comparedToVersion;
            return this;
        }

        @Generated
        public ChangelogBuilder jiraIssueKeys(@NonNull Set<String> jiraIssueKeys) {
            if (jiraIssueKeys == null) {
                throw new NullPointerException("jiraIssueKeys is marked non-null but is null");
            }
            this.jiraIssueKeys = jiraIssueKeys;
            return this;
        }

        @Generated
        public Changelog build() {
            return new Changelog(this.comment, this.comparedToVersion, this.jiraIssueKeys);
        }

        @Generated
        public String toString() {
            return "Changelog.ChangelogBuilder(comment=" + this.comment + ", comparedToVersion=" + this.comparedToVersion + ", jiraIssueKeys=" + String.valueOf(this.jiraIssueKeys) + ")";
        }
    }
}

