/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentUnit;
import ch.admin.bit.jeap.deploymentlog.domain.VersionNumber;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class ComponentVersion {
    @Id
    private UUID id;
    @NonNull
    private String versionName;
    private ZonedDateTime taggedAt;
    @Embedded
    private VersionNumber versionNumber;
    @NonNull
    private String versionControlUrl;
    @NonNull
    private String commitRef;
    @NonNull
    private ZonedDateTime committedAt;
    private boolean publishedVersion;
    @Embedded
    @NonNull
    private DeploymentUnit deploymentUnit;
    @ManyToOne(fetch=FetchType.LAZY)
    @NonNull
    private Component component;

    private ComponentVersion(@NonNull String versionName, ZonedDateTime taggedAt, @NonNull String versionControlUrl, @NonNull String commitRef, @NonNull ZonedDateTime committedAt, boolean publishedVersion, @NonNull Component component, @NonNull DeploymentUnit deploymentUnit) {
        if (versionName == null) {
            throw new NullPointerException("versionName is marked non-null but is null");
        }
        if (versionControlUrl == null) {
            throw new NullPointerException("versionControlUrl is marked non-null but is null");
        }
        if (commitRef == null) {
            throw new NullPointerException("commitRef is marked non-null but is null");
        }
        if (committedAt == null) {
            throw new NullPointerException("committedAt is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (deploymentUnit == null) {
            throw new NullPointerException("deploymentUnit is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.versionName = versionName;
        this.taggedAt = taggedAt;
        this.versionNumber = VersionNumber.of(versionName);
        this.versionControlUrl = versionControlUrl;
        this.commitRef = commitRef;
        this.committedAt = committedAt;
        this.publishedVersion = publishedVersion;
        this.deploymentUnit = deploymentUnit;
        this.component = component;
    }

    @Generated
    public static ComponentVersionBuilder builder() {
        return new ComponentVersionBuilder();
    }

    @Generated
    protected ComponentVersion() {
    }

    @Generated
    public String toString() {
        return "ComponentVersion(id=" + String.valueOf(this.getId()) + ", versionName=" + this.getVersionName() + ", taggedAt=" + String.valueOf(this.getTaggedAt()) + ", versionNumber=" + String.valueOf(this.getVersionNumber()) + ", versionControlUrl=" + this.getVersionControlUrl() + ", commitRef=" + this.getCommitRef() + ", committedAt=" + String.valueOf(this.getCommittedAt()) + ", publishedVersion=" + this.isPublishedVersion() + ", deploymentUnit=" + String.valueOf(this.getDeploymentUnit()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getVersionName() {
        return this.versionName;
    }

    @Generated
    public ZonedDateTime getTaggedAt() {
        return this.taggedAt;
    }

    @Generated
    public VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    @NonNull
    @Generated
    public String getVersionControlUrl() {
        return this.versionControlUrl;
    }

    @NonNull
    @Generated
    public String getCommitRef() {
        return this.commitRef;
    }

    @NonNull
    @Generated
    public ZonedDateTime getCommittedAt() {
        return this.committedAt;
    }

    @Generated
    public boolean isPublishedVersion() {
        return this.publishedVersion;
    }

    @NonNull
    @Generated
    public DeploymentUnit getDeploymentUnit() {
        return this.deploymentUnit;
    }

    @NonNull
    @Generated
    public Component getComponent() {
        return this.component;
    }

    @Generated
    public static class ComponentVersionBuilder {
        @Generated
        private String versionName;
        @Generated
        private ZonedDateTime taggedAt;
        @Generated
        private String versionControlUrl;
        @Generated
        private String commitRef;
        @Generated
        private ZonedDateTime committedAt;
        @Generated
        private boolean publishedVersion;
        @Generated
        private Component component;
        @Generated
        private DeploymentUnit deploymentUnit;

        @Generated
        ComponentVersionBuilder() {
        }

        @Generated
        public ComponentVersionBuilder versionName(@NonNull String versionName) {
            if (versionName == null) {
                throw new NullPointerException("versionName is marked non-null but is null");
            }
            this.versionName = versionName;
            return this;
        }

        @Generated
        public ComponentVersionBuilder taggedAt(ZonedDateTime taggedAt) {
            this.taggedAt = taggedAt;
            return this;
        }

        @Generated
        public ComponentVersionBuilder versionControlUrl(@NonNull String versionControlUrl) {
            if (versionControlUrl == null) {
                throw new NullPointerException("versionControlUrl is marked non-null but is null");
            }
            this.versionControlUrl = versionControlUrl;
            return this;
        }

        @Generated
        public ComponentVersionBuilder commitRef(@NonNull String commitRef) {
            if (commitRef == null) {
                throw new NullPointerException("commitRef is marked non-null but is null");
            }
            this.commitRef = commitRef;
            return this;
        }

        @Generated
        public ComponentVersionBuilder committedAt(@NonNull ZonedDateTime committedAt) {
            if (committedAt == null) {
                throw new NullPointerException("committedAt is marked non-null but is null");
            }
            this.committedAt = committedAt;
            return this;
        }

        @Generated
        public ComponentVersionBuilder publishedVersion(boolean publishedVersion) {
            this.publishedVersion = publishedVersion;
            return this;
        }

        @Generated
        public ComponentVersionBuilder component(@NonNull Component component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.component = component;
            return this;
        }

        @Generated
        public ComponentVersionBuilder deploymentUnit(@NonNull DeploymentUnit deploymentUnit) {
            if (deploymentUnit == null) {
                throw new NullPointerException("deploymentUnit is marked non-null but is null");
            }
            this.deploymentUnit = deploymentUnit;
            return this;
        }

        @Generated
        public ComponentVersion build() {
            return new ComponentVersion(this.versionName, this.taggedAt, this.versionControlUrl, this.commitRef, this.committedAt, this.publishedVersion, this.component, this.deploymentUnit);
        }

        @Generated
        public String toString() {
            return "ComponentVersion.ComponentVersionBuilder(versionName=" + this.versionName + ", taggedAt=" + String.valueOf(this.taggedAt) + ", versionControlUrl=" + this.versionControlUrl + ", commitRef=" + this.commitRef + ", committedAt=" + String.valueOf(this.committedAt) + ", publishedVersion=" + this.publishedVersion + ", component=" + String.valueOf(this.component) + ", deploymentUnit=" + String.valueOf(this.deploymentUnit) + ")";
        }
    }
}

