/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import ch.admin.bit.jeap.deploymentlog.domain.System;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="SYSTEM_ALIAS_NAME_UK", columnNames={"name"})})
public class SystemAlias {
    @Id
    private UUID id;
    @NonNull
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    private System system;

    public SystemAlias(@NonNull String name, @NonNull System system) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.name = name.toLowerCase();
        this.system = system;
    }

    @Generated
    private SystemAlias(UUID id, @NonNull String name, System system) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.system = system;
    }

    @Generated
    protected SystemAlias() {
    }

    @Generated
    public String toString() {
        return "SystemAlias(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public System getSystem() {
        return this.system;
    }
}

