/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import jakarta.persistence.Embeddable;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Embeddable
public class VersionNumber
implements Comparable<VersionNumber> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionNumber.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(?<major>\\d+)(\\.(?<minor>\\d+))?(\\.(?<patch>\\d+))?([._-](?<build>\\d+))?([._-](?<postfix>.+))?$");
    @NonNull
    private BigDecimal majorVersion;
    private BigDecimal minorVersion;
    private BigDecimal patchVersion;
    private BigDecimal buildVersion;
    private String postfix;

    public static VersionNumber of(String version) {
        try {
            Matcher matcher = VERSION_PATTERN.matcher(version);
            if (matcher.matches()) {
                String postfix = matcher.group("postfix");
                BigDecimal major = VersionNumber.numberFromMatchedGroup(matcher, "major");
                if (major != null) {
                    return new VersionNumber(major, VersionNumber.numberFromMatchedGroup(matcher, "minor"), VersionNumber.numberFromMatchedGroup(matcher, "patch"), VersionNumber.numberFromMatchedGroup(matcher, "build"), postfix);
                }
            }
        }
        catch (Exception ex) {
            log.error("Unparseable version number", (Throwable)ex);
        }
        log.warn("The actual version '{}' does not match the pattern", (Object)version);
        return null;
    }

    private static BigDecimal numberFromMatchedGroup(Matcher matcher, String groupName) {
        String match = matcher.group(groupName);
        return match == null ? null : new BigDecimal(match);
    }

    public String toString() {
        return String.valueOf(this.majorVersion) + VersionNumber.dotVersionNullSafe(this.minorVersion) + VersionNumber.dotVersionNullSafe(this.patchVersion) + VersionNumber.dotVersionNullSafe(this.buildVersion) + VersionNumber.dotVersionNullSafe(this.postfix);
    }

    private static String dotVersionNullSafe(Object value) {
        return value == null ? "" : "." + String.valueOf(value);
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (other == null) {
            return 1;
        }
        int major = this.compare(this.majorVersion, other.majorVersion) * 10000;
        int minor = this.compare(this.minorVersion, other.minorVersion) * 1000;
        int patch = this.compare(this.patchVersion, other.patchVersion) * 100;
        int build = this.compare(this.buildVersion, other.buildVersion) * 10;
        int hasPostfix = this.comparePostfix(this.postfix == null, other.postfix == null);
        return major + minor + patch + build + hasPostfix;
    }

    private int comparePostfix(boolean hasPostfix, boolean otherHasPostfix) {
        return Boolean.compare(hasPostfix, otherHasPostfix);
    }

    private int compare(BigDecimal thisVersion, BigDecimal otherVersion) {
        if (thisVersion == null && otherVersion == null) {
            return 0;
        }
        if (thisVersion == null) {
            return -1;
        }
        if (otherVersion == null) {
            return 1;
        }
        return thisVersion.compareTo(otherVersion);
    }

    @Generated
    private VersionNumber(@NonNull BigDecimal majorVersion, BigDecimal minorVersion, BigDecimal patchVersion, BigDecimal buildVersion, String postfix) {
        if (majorVersion == null) {
            throw new NullPointerException("majorVersion is marked non-null but is null");
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
        this.buildVersion = buildVersion;
        this.postfix = postfix;
    }

    @Generated
    protected VersionNumber() {
    }

    @NonNull
    @Generated
    public BigDecimal getMajorVersion() {
        return this.majorVersion;
    }

    @Generated
    public BigDecimal getMinorVersion() {
        return this.minorVersion;
    }

    @Generated
    public BigDecimal getPatchVersion() {
        return this.patchVersion;
    }

    @Generated
    public BigDecimal getBuildVersion() {
        return this.buildVersion;
    }

    @Generated
    public String getPostfix() {
        return this.postfix;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionNumber)) {
            return false;
        }
        VersionNumber other = (VersionNumber)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$majorVersion = this.getMajorVersion();
        BigDecimal other$majorVersion = other.getMajorVersion();
        if (this$majorVersion == null ? other$majorVersion != null : !((Object)this$majorVersion).equals(other$majorVersion)) {
            return false;
        }
        BigDecimal this$minorVersion = this.getMinorVersion();
        BigDecimal other$minorVersion = other.getMinorVersion();
        if (this$minorVersion == null ? other$minorVersion != null : !((Object)this$minorVersion).equals(other$minorVersion)) {
            return false;
        }
        BigDecimal this$patchVersion = this.getPatchVersion();
        BigDecimal other$patchVersion = other.getPatchVersion();
        if (this$patchVersion == null ? other$patchVersion != null : !((Object)this$patchVersion).equals(other$patchVersion)) {
            return false;
        }
        BigDecimal this$buildVersion = this.getBuildVersion();
        BigDecimal other$buildVersion = other.getBuildVersion();
        if (this$buildVersion == null ? other$buildVersion != null : !((Object)this$buildVersion).equals(other$buildVersion)) {
            return false;
        }
        String this$postfix = this.getPostfix();
        String other$postfix = other.getPostfix();
        return !(this$postfix == null ? other$postfix != null : !this$postfix.equals(other$postfix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VersionNumber;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $majorVersion = this.getMajorVersion();
        result = result * 59 + ($majorVersion == null ? 43 : ((Object)$majorVersion).hashCode());
        BigDecimal $minorVersion = this.getMinorVersion();
        result = result * 59 + ($minorVersion == null ? 43 : ((Object)$minorVersion).hashCode());
        BigDecimal $patchVersion = this.getPatchVersion();
        result = result * 59 + ($patchVersion == null ? 43 : ((Object)$patchVersion).hashCode());
        BigDecimal $buildVersion = this.getBuildVersion();
        result = result * 59 + ($buildVersion == null ? 43 : ((Object)$buildVersion).hashCode());
        String $postfix = this.getPostfix();
        result = result * 59 + ($postfix == null ? 43 : $postfix.hashCode());
        return result;
    }
}

