/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import ch.admin.bit.jeap.deploymentlog.domain.ComponentVersion;
import ch.admin.bit.jeap.deploymentlog.domain.System;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class Component {
    @Id
    private UUID id;
    private String name;
    private boolean active;
    @OneToMany(mappedBy="component", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Set<ComponentVersion> componentVersions;
    @ManyToOne(fetch=FetchType.LAZY)
    private System system;

    public Component(@NonNull String name, System system) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.name = name;
        this.system = system;
        this.active = true;
    }

    public void inactive() {
        this.active = false;
    }

    public void updateSystem(System system) {
        this.system = system;
    }

    @Generated
    private Component(UUID id, String name, boolean active, Set<ComponentVersion> componentVersions, System system) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.componentVersions = componentVersions;
        this.system = system;
    }

    @Generated
    protected Component() {
    }

    @Generated
    public String toString() {
        return "Component(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", active=" + this.isActive() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public System getSystem() {
        return this.system;
    }
}

