/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import ch.admin.bit.jeap.db.tx.TransactionalReadReplica;
import ch.admin.bit.jeap.deploymentlog.domain.Changelog;
import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.ComponentVersion;
import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPage;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPageRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentSequence;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentState;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentTarget;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentType;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentUnit;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionState;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionStateRepository;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.Link;
import ch.admin.bit.jeap.deploymentlog.domain.SystemEnv;
import ch.admin.bit.jeap.deploymentlog.domain.SystemRepository;
import ch.admin.bit.jeap.deploymentlog.domain.SystemService;
import ch.admin.bit.jeap.deploymentlog.domain.exception.DeploymentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.DeploymentPageNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.InvalidDeploymentStateForUpdateException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@org.springframework.stereotype.Component
@Transactional
public class DeploymentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploymentService.class);
    private final DeploymentRepository deploymentRepository;
    private final DeploymentPageRepository deploymentPageRepository;
    private final SystemRepository systemRepository;
    private final EnvironmentRepository environmentRepository;
    private final SystemService systemService;
    private final EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository;

    public UUID createDeployment(String externalId, String versionName, ZonedDateTime taggedAt, String versionCtrlUrl, String commitRef, ZonedDateTime committedAt, boolean publishedVersion, String systemName, String componentName, String environmentName, DeploymentTarget target, ZonedDateTime startedAt, String startedBy, DeploymentUnit deploymentUnit, Set<Link> links, Map<String, String> properties, Set<String> referenceIdentifiers, String changelogComment, String changelogComparedToVersion, Set<String> changelogJiraIssueKeys, String remedyChangeId, Set<DeploymentType> deploymentTypes) {
        Component component = this.systemService.retrieveOrCreateComponent(systemName, componentName);
        Environment environment = this.retrieveOrCreateEnvironmentByName(environmentName);
        ComponentVersion componentVersion = ComponentVersion.builder().versionName(versionName).taggedAt(taggedAt).versionControlUrl(versionCtrlUrl).commitRef(commitRef).committedAt(committedAt).publishedVersion(publishedVersion).component(component).deploymentUnit(deploymentUnit).build();
        Deployment deployment = Deployment.builder().externalId(externalId).startedAt(startedAt).startedBy(startedBy).environment(environment).target(target).componentVersion(componentVersion).links(links).changelog(this.createChangelog(changelogComment, changelogComparedToVersion, changelogJiraIssueKeys)).sequence(this.getDeploymentSequence(component, environment, versionName)).remedyChangeId(remedyChangeId).properties(properties).referenceIdentifiers(referenceIdentifiers).deploymentTypes(deploymentTypes).build();
        return this.deploymentRepository.save(deployment).getId();
    }

    public UUID createUndeployment(Deployment previousDeployment, String externalId, String systemName, String componentName, String environmentName, ZonedDateTime startedAt, String startedBy, String remedyChangeId) {
        Component component = this.systemService.retrieveOrCreateComponent(systemName, componentName);
        Environment environment = this.retrieveOrCreateEnvironmentByName(environmentName);
        ComponentVersion componentVersion = ComponentVersion.builder().versionName("(undeployed)").taggedAt(previousDeployment.getComponentVersion().getTaggedAt()).versionControlUrl(previousDeployment.getComponentVersion().getVersionControlUrl()).commitRef(previousDeployment.getComponentVersion().getCommitRef()).committedAt(previousDeployment.getComponentVersion().getCommittedAt()).publishedVersion(previousDeployment.getComponentVersion().isPublishedVersion()).component(component).deploymentUnit(previousDeployment.getComponentVersion().getDeploymentUnit()).build();
        Deployment deployment = Deployment.builder().externalId(externalId).startedAt(startedAt).startedBy(startedBy).environment(environment).target(previousDeployment.getTarget()).componentVersion(componentVersion).sequence(DeploymentSequence.UNDEPLOYED).remedyChangeId(remedyChangeId).build();
        return this.deploymentRepository.save(deployment).getId();
    }

    private DeploymentSequence getDeploymentSequence(Component component, Environment environment, String versionName) {
        Optional<EnvironmentComponentVersionState> currentDeploymentState = this.environmentComponentVersionStateRepository.findByEnvironmentAndComponent(environment, component);
        if (currentDeploymentState.isEmpty()) {
            return DeploymentSequence.FIRST;
        }
        if (currentDeploymentState.get().getComponentVersion().getVersionName().equals(versionName)) {
            return DeploymentSequence.REPEATED;
        }
        return DeploymentSequence.NEW;
    }

    private Changelog createChangelog(String changelogComment, String changelogComparedToVersion, Set<String> changelogJiraIssueKeys) {
        if (changelogComment != null || changelogJiraIssueKeys != null) {
            return Changelog.builder().comment(changelogComment).jiraIssueKeys(changelogJiraIssueKeys).comparedToVersion(changelogComparedToVersion).build();
        }
        return null;
    }

    public UUID updateState(String externalId, DeploymentState state, String stateMessage, ZonedDateTime endedAt, Map<String, String> properties) throws DeploymentNotFoundException, InvalidDeploymentStateForUpdateException {
        Deployment deployment = this.retrieveDeploymentByExternalId(externalId);
        deployment.getProperties().putAll(properties);
        switch (state) {
            case SUCCESS: {
                deployment.success(endedAt, stateMessage);
                if (deployment.getSequence() == DeploymentSequence.UNDEPLOYED) break;
                this.updateEnvironmentComponentVersionState(deployment);
                break;
            }
            case FAILURE: {
                deployment.failed(endedAt, stateMessage);
                break;
            }
            default: {
                throw new InvalidDeploymentStateForUpdateException(state);
            }
        }
        return deployment.getId();
    }

    @TransactionalReadReplica
    public Optional<Deployment> findByExternalId(String externalId) {
        log.debug("Find the deployment with externalId '{}'", (Object)externalId);
        return this.deploymentRepository.findByExternalId(externalId);
    }

    @TransactionalReadReplica
    public Deployment getDeployment(String externalId) throws DeploymentNotFoundException {
        log.debug("Retrieve the deployment with externalId '{}'", (Object)externalId);
        return this.retrieveDeploymentByExternalId(externalId);
    }

    @TransactionalReadReplica
    public DeploymentPage getDeploymentPage(String externalId) throws DeploymentNotFoundException, DeploymentPageNotFoundException {
        log.debug("Retrieve the deployment page for the deployment with externalId '{}'", (Object)externalId);
        return this.deploymentPageRepository.findDeploymentPageByDeploymentId(this.retrieveDeploymentByExternalId(externalId).getId()).orElseThrow(() -> new DeploymentPageNotFoundException(externalId));
    }

    private Deployment retrieveDeploymentByExternalId(String externalId) throws DeploymentNotFoundException {
        return this.deploymentRepository.findByExternalId(externalId).orElseThrow(() -> new DeploymentNotFoundException(externalId));
    }

    private Environment retrieveOrCreateEnvironmentByName(String name) {
        return this.environmentRepository.findByName(name).orElseGet(() -> this.environmentRepository.save(new Environment(name)));
    }

    private void updateEnvironmentComponentVersionState(Deployment deployment) {
        Optional<EnvironmentComponentVersionState> snapshot = this.environmentComponentVersionStateRepository.findByEnvironmentAndComponent(deployment.getEnvironment(), deployment.getComponentVersion().getComponent());
        if (snapshot.isPresent()) {
            log.info("Updating current EnvironmentComponentVersionState {} with new version '{}' and deployment '{}'", new Object[]{snapshot.get(), deployment.getComponentVersion().getVersionName(), deployment.getEndedAt().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)});
            snapshot.get().updateVersion(deployment.getComponentVersion(), deployment);
        } else {
            EnvironmentComponentVersionState envSaved = this.environmentComponentVersionStateRepository.save(EnvironmentComponentVersionState.fromDeployment(deployment));
            log.info("Created new EnvironmentComponentVersionState {}", (Object)envSaved);
        }
    }

    @TransactionalReadReplica
    public List<UUID> getMissingDeploymentPages(int limit, long minAgeMinutes, long maxAgeMinutes) {
        ZonedDateTime from = ZonedDateTime.now().minusMinutes(maxAgeMinutes);
        ZonedDateTime to = ZonedDateTime.now().minusMinutes(minAgeMinutes);
        return this.deploymentRepository.getDeploymentIdsWithMissingOrOutdatedGeneratedPages(limit, from, to);
    }

    @TransactionalReadReplica
    public long countMissingDeploymentPages(int maxAgeDays) {
        ZonedDateTime from = ZonedDateTime.now().minusDays(maxAgeDays);
        return this.deploymentRepository.countDeploymentsWithMissingOrOutdatedGeneratedPages(from);
    }

    @TransactionalReadReplica
    public List<DeploymentPage> getOutdatedNonProductiveDeploymentPages(Duration minAge, int keepAtLeastPageCount) {
        ZonedDateTime to = ZonedDateTime.now().minus(minAge);
        return this.systemRepository.getAllSystemIds().stream().flatMap(systemId -> this.getOutdatedNonProductiveDeploymentPagesForSystem((UUID)systemId, keepAtLeastPageCount, to)).toList();
    }

    private Stream<DeploymentPage> getOutdatedNonProductiveDeploymentPagesForSystem(UUID systemId, int keepAtLeastPageCount, ZonedDateTime to) {
        List<Environment> envs = this.environmentRepository.findNonProductiveEnvironmentsForSystemId(systemId);
        return envs.stream().flatMap(env -> this.getOutdatedPagesForEnvironment(systemId, keepAtLeastPageCount, to, (Environment)env));
    }

    private Stream<DeploymentPage> getOutdatedPagesForEnvironment(UUID systemId, int keepAtLeastPageCount, ZonedDateTime to, Environment env) {
        List<DeploymentPage> deploymentPages = this.deploymentPageRepository.getSystemDeploymentPagesForEnvironments(systemId, List.of(env));
        return deploymentPages.stream().skip(keepAtLeastPageCount).filter(page -> page.getDeploymentStateTimestamp().isBefore(to)).filter(this::canDeleteDeploymentPage);
    }

    boolean canDeleteDeploymentPage(DeploymentPage page) {
        Optional<Deployment> deploymentOptional = this.deploymentRepository.findById(page.getDeploymentId());
        if (deploymentOptional.isEmpty()) {
            return true;
        }
        Deployment deployment = deploymentOptional.get();
        return !this.pageShowsLastSuccessfulDeploymentOrNewer(page, deployment) && !this.pageShowsNewestDeployment(page, deployment);
    }

    private boolean pageShowsLastSuccessfulDeploymentOrNewer(DeploymentPage page, Deployment deployment) {
        Optional<Deployment> lastSuccess = this.deploymentRepository.getLastSuccessfulDeploymentForComponent(deployment.getComponentVersion().getComponent(), deployment.getEnvironment());
        if (lastSuccess.isEmpty()) {
            return false;
        }
        Deployment lastSuccessfulDeployment = lastSuccess.get();
        boolean pageIsForLastSuccess = lastSuccessfulDeployment.getId().equals(page.getDeploymentId());
        boolean pageIsForDeploymentNewerThanLastSuccess = deployment.getStartedAt().isAfter(lastSuccessfulDeployment.getStartedAt());
        return pageIsForLastSuccess || pageIsForDeploymentNewerThanLastSuccess;
    }

    private boolean pageShowsNewestDeployment(DeploymentPage page, Deployment deployment) {
        Optional<Deployment> lastDeployment = this.deploymentRepository.getLastDeploymentForComponent(deployment.getComponentVersion().getComponent(), deployment.getEnvironment());
        return lastDeployment.isPresent() && lastDeployment.get().getId().equals(page.getDeploymentId());
    }

    @TransactionalReadReplica
    public Set<SystemEnv> getSystemAndEnvsForDeploymentIds(Set<UUID> deploymentIds) {
        return deploymentIds.stream().map(this.deploymentRepository::getById).map(SystemEnv::from).collect(Collectors.toSet());
    }

    @TransactionalReadReplica
    public Deployment getLastDeploymentForComponent(Component component, Environment env) {
        return this.deploymentRepository.getLastDeploymentForComponent(component, env).orElseThrow(() -> new IllegalStateException(String.format("Last deployment not found for component '%s' in environment '%s'", component.getName(), env.getName())));
    }

    @Generated
    public DeploymentService(DeploymentRepository deploymentRepository, DeploymentPageRepository deploymentPageRepository, SystemRepository systemRepository, EnvironmentRepository environmentRepository, SystemService systemService, EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository) {
        this.deploymentRepository = deploymentRepository;
        this.deploymentPageRepository = deploymentPageRepository;
        this.systemRepository = systemRepository;
        this.environmentRepository = environmentRepository;
        this.systemService = systemService;
        this.environmentComponentVersionStateRepository = environmentComponentVersionStateRepository;
    }
}

