/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import ch.admin.bit.jeap.db.tx.TransactionalReadReplica;
import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.ComponentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionState;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionStateRepository;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.System;
import ch.admin.bit.jeap.deploymentlog.domain.SystemAlias;
import ch.admin.bit.jeap.deploymentlog.domain.SystemAliasRepository;
import ch.admin.bit.jeap.deploymentlog.domain.SystemRepository;
import ch.admin.bit.jeap.deploymentlog.domain.exception.AliasNameAlreadyDefinedException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.ComponentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.EnvironmentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.SystemNameAlreadyDefinedException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.SystemNotFoundException;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@org.springframework.stereotype.Component
public class SystemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemService.class);
    private final SystemRepository systemRepository;
    private final EnvironmentRepository environmentRepository;
    private final DeploymentRepository deploymentRepository;
    private final ComponentRepository componentRepository;
    private final EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository;
    private final SystemAliasRepository systemAliasRepository;

    @Transactional
    public void deleteComponent(String systemName, String componentName, String environmentName) throws SystemNotFoundException, EnvironmentNotFoundException, ComponentNotFoundException {
        System system = this.retrieveSystemByName(systemName);
        Component component = this.retrieveComponentByName(system, componentName);
        Environment environment = this.retrieveEnvironmentByName(environmentName);
        this.environmentComponentVersionStateRepository.deleteByComponentEqualsAndEnvironmentEquals(component, environment);
        boolean componentNotDeployedAnywhere = this.environmentComponentVersionStateRepository.findByComponentIn(Collections.singleton(component)).isEmpty();
        if (componentNotDeployedAnywhere) {
            component.inactive();
        }
    }

    @TransactionalReadReplica
    public System retrieveSystemByName(String name) throws SystemNotFoundException {
        return this.retrieveSystemByNameOrAlias(name).orElseThrow(() -> new SystemNotFoundException(name));
    }

    @Transactional
    public Component retrieveComponentByName(String systemName, String componentName) throws SystemNotFoundException, ComponentNotFoundException {
        System system = this.retrieveSystemByName(systemName);
        return this.retrieveComponentByName(system, componentName);
    }

    private Component retrieveComponentByName(System system, String componentName) throws ComponentNotFoundException {
        return system.getComponents().stream().filter(c -> c.getName().equals(componentName)).findFirst().orElseThrow(() -> new ComponentNotFoundException(system.getName(), componentName));
    }

    public Environment retrieveEnvironmentByName(String name) throws EnvironmentNotFoundException {
        return this.environmentRepository.findByName(name).orElseThrow(() -> new EnvironmentNotFoundException(name));
    }

    @TransactionalReadReplica
    public Optional<String> getCurrentVersionOfComponent(String systemName, String componentName, String environmentName) throws SystemNotFoundException, ComponentNotFoundException, EnvironmentNotFoundException {
        Component component = this.retrieveComponentByName(this.retrieveSystemByName(systemName), componentName);
        Environment environment = this.retrieveEnvironmentByName(environmentName);
        return this.environmentComponentVersionStateRepository.findByEnvironmentAndComponent(environment, component).map(envState -> envState.getComponentVersion().getVersionName());
    }

    @TransactionalReadReplica
    public Optional<Deployment> getCurrentDeploymentOfComponent(String systemName, String componentName, String environmentName) throws SystemNotFoundException, ComponentNotFoundException, EnvironmentNotFoundException {
        Component component = this.retrieveComponentByName(this.retrieveSystemByName(systemName), componentName);
        Environment environment = this.retrieveEnvironmentByName(environmentName);
        return this.environmentComponentVersionStateRepository.findByEnvironmentAndComponent(environment, component).map(EnvironmentComponentVersionState::getDeployment);
    }

    @TransactionalReadReplica
    public Optional<String> getPreviousVersionOfComponent(String systemName, String componentName, String environmentName, String version) throws SystemNotFoundException, ComponentNotFoundException, EnvironmentNotFoundException {
        Optional<String> currentVersionOfComponent = this.getCurrentVersionOfComponent(systemName, componentName, environmentName);
        if (currentVersionOfComponent.isEmpty() || !currentVersionOfComponent.get().equals(version)) {
            return currentVersionOfComponent;
        }
        Component component = this.retrieveComponentByName(this.retrieveSystemByName(systemName), componentName);
        Environment environment = this.retrieveEnvironmentByName(environmentName);
        Optional<String> previousVersion = this.deploymentRepository.getLastSuccessfulDeploymentForComponentDifferentToVersion(component, environment, version).map(d -> d.getComponentVersion().getVersionName());
        previousVersion.ifPresent(s -> log.info("Found previousVersion '{}'", s));
        return previousVersion;
    }

    @TransactionalReadReplica
    public Optional<Deployment> getPreviousDeploymentOfComponent(String systemName, String componentName, String environmentName, String version) throws SystemNotFoundException, ComponentNotFoundException, EnvironmentNotFoundException {
        Optional<String> currentVersionOfComponent = this.getCurrentVersionOfComponent(systemName, componentName, environmentName);
        if (currentVersionOfComponent.isEmpty() || !currentVersionOfComponent.get().equals(version)) {
            return this.getCurrentDeploymentOfComponent(systemName, componentName, environmentName);
        }
        Component component = this.retrieveComponentByName(this.retrieveSystemByName(systemName), componentName);
        Environment environment = this.retrieveEnvironmentByName(environmentName);
        Optional<Deployment> previousDeployment = this.deploymentRepository.getLastSuccessfulDeploymentForComponentDifferentToVersion(component, environment, version);
        previousDeployment.ifPresent(s -> log.info("Found previousDeployment '{}'", s));
        return previousDeployment;
    }

    @Transactional
    public Component retrieveOrCreateComponent(String systemName, String componentName) {
        System system = this.retrieveOrCreateSystemByNameOrAlias(systemName);
        Optional<Component> component = system.getComponents().stream().filter(c -> c.getName().equals(componentName)).findFirst();
        return component.orElseGet(() -> this.componentRepository.save(new Component(componentName, system)));
    }

    private Optional<System> retrieveSystemByNameOrAlias(String systemName) {
        Optional<System> system = this.systemRepository.findByNameIgnoreCase(systemName);
        if (system.isPresent()) {
            log.debug("System found with name {}", (Object)system.get().getName());
            return system;
        }
        Optional<SystemAlias> systemAlias = this.systemAliasRepository.findByName(systemName);
        if (systemAlias.isPresent()) {
            log.debug("System alias found with name {}", (Object)systemName);
            return Optional.of(systemAlias.get().getSystem());
        }
        return Optional.empty();
    }

    private System retrieveOrCreateSystemByNameOrAlias(String systemName) {
        Optional<System> system = this.retrieveSystemByNameOrAlias(systemName);
        if (system.isPresent()) {
            return system.get();
        }
        log.info("System not found with name {}. Creating a new one...", (Object)systemName);
        return this.systemRepository.save(new System(systemName));
    }

    @Transactional
    public void createAlias(String systemName, String alias) throws SystemNotFoundException, AliasNameAlreadyDefinedException, SystemNameAlreadyDefinedException {
        System system = this.retrieveSystemByName(systemName);
        if (this.systemRepository.findByNameIgnoreCase(alias).isPresent()) {
            throw SystemNameAlreadyDefinedException.systemNameAlreadyDefined(alias);
        }
        if (this.systemAliasRepository.findByName(alias).isPresent()) {
            throw AliasNameAlreadyDefinedException.aliasNameAlreadyDefined(alias);
        }
        this.systemAliasRepository.save(new SystemAlias(alias, system));
    }

    @Transactional
    public System updateSystemName(String oldSystemName, String newSystemName) throws SystemNotFoundException, AliasNameAlreadyDefinedException, SystemNameAlreadyDefinedException {
        System system = this.retrieveSystemByName(oldSystemName);
        if (this.systemRepository.findByNameIgnoreCase(newSystemName).isPresent()) {
            throw SystemNameAlreadyDefinedException.systemNameAlreadyDefined(newSystemName);
        }
        if (this.systemAliasRepository.findByName(newSystemName).isPresent()) {
            throw AliasNameAlreadyDefinedException.aliasNameAlreadyDefined(newSystemName);
        }
        system.updateName(newSystemName);
        this.systemAliasRepository.save(new SystemAlias(oldSystemName, system));
        return system;
    }

    @Transactional
    public void mergeSystems(System system, System oldSystem) {
        this.logSystemComponents(oldSystem);
        this.logSystemComponents(system);
        log.info("Moving {} components from system {} into {}", new Object[]{oldSystem.getComponents().size(), oldSystem.getName(), system.getName()});
        for (Component component : oldSystem.getComponents()) {
            log.info("Component {} assigned to system {}", (Object)component.getName(), (Object)system.getName());
            component.updateSystem(system);
            system.getComponents().add(component);
        }
        oldSystem.getComponents().clear();
        this.logSystemComponents(oldSystem);
        this.logSystemComponents(system);
        this.systemRepository.delete(oldSystem);
        this.systemAliasRepository.save(new SystemAlias(oldSystem.getName(), system));
    }

    private void logSystemComponents(System system) {
        log.info("System '{}' contains {} components", (Object)system.getName(), (Object)system.getComponents().size());
    }

    @Generated
    public SystemService(SystemRepository systemRepository, EnvironmentRepository environmentRepository, DeploymentRepository deploymentRepository, ComponentRepository componentRepository, EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository, SystemAliasRepository systemAliasRepository) {
        this.systemRepository = systemRepository;
        this.environmentRepository = environmentRepository;
        this.deploymentRepository = deploymentRepository;
        this.componentRepository = componentRepository;
        this.environmentComponentVersionStateRepository = environmentComponentVersionStateRepository;
        this.systemAliasRepository = systemAliasRepository;
    }
}

