/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.domain;

import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.SystemAlias;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(name="SYSTEM_NAME_UK", columnNames={"name"})})
public class System {
    @Id
    private UUID id;
    @NonNull
    private String name;
    @OneToMany(mappedBy="system", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Set<Component> components;
    @OneToMany(mappedBy="system", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private Set<SystemAlias> aliases;

    public System(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.name = name;
        this.components = new HashSet<Component>();
        this.aliases = new HashSet<SystemAlias>();
    }

    public void updateName(String name) {
        this.name = name;
    }

    @Generated
    private System(UUID id, @NonNull String name, Set<Component> components, Set<SystemAlias> aliases) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.components = components;
        this.aliases = aliases;
    }

    @Generated
    protected System() {
    }

    @Generated
    public String toString() {
        return "System(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", aliases=" + String.valueOf(this.getAliases()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Set<Component> getComponents() {
        return this.components;
    }

    @Generated
    public Set<SystemAlias> getAliases() {
        return this.aliases;
    }
}

