/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.jira;

import ch.admin.bit.jeap.deploymentlog.jira.JiraIssuesNotFoundException;
import ch.admin.bit.jeap.deploymentlog.jira.JiraWebClient;
import ch.admin.bit.jeap.deploymentlog.jira.JiraWebClientProperties;
import ch.admin.bit.jeap.deploymentlog.jira.dto.JiraErrorResponse;
import ch.admin.bit.jeap.deploymentlog.jira.dto.JiraIssueDto;
import ch.admin.bit.jeap.deploymentlog.jira.dto.JiraSearchResultDto;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriComponentsBuilder;

public class JiraWebClientImpl
implements JiraWebClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraWebClientImpl.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Pattern pattern = Pattern.compile("'(.*?)'");
    private final RestClient restClient;
    private final String documentationRootUrl;
    private final String appId;

    public JiraWebClientImpl(JiraWebClientProperties props, String documentationRootUrl, RestClient.Builder restClientBuilder) {
        this.documentationRootUrl = documentationRootUrl;
        this.appId = props.getAppId();
        this.restClient = restClientBuilder.defaultHeaders(header -> header.setBasicAuth(props.getUsername(), props.getPassword())).baseUrl(UriComponentsBuilder.fromHttpUrl((String)props.getUrl()).pathSegment(new String[]{"rest", "api", "2"}).build().toString()).build();
    }

    @Override
    public void updateIssueWithConfluenceLink(String jiraIssueKey, String pageId) {
        String url = "/issue/" + jiraIssueKey + "/remotelink";
        log.debug("Call jira api with url '{}' and pageId '{}'", (Object)url, (Object)pageId);
        String confluenceLink = this.documentationRootUrl + pageId;
        String updateIssueBodyValue = "{    \"application\": {        \"type\": \"com.atlassian.confluence\",        \"name\": \"Confluence\"    },    \"relationship\": \"mentioned in\",    \"globalId\": \"appId=%3$s&pageId=%1$s\",    \"object\": {        \"url\": \"%2$s\",        \"title\": \"Page\"    }}";
        ((RestClient.RequestBodySpec)this.restClient.post().uri(url, new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)"{    \"application\": {        \"type\": \"com.atlassian.confluence\",        \"name\": \"Confluence\"    },    \"relationship\": \"mentioned in\",    \"globalId\": \"appId=%3$s&pageId=%1$s\",    \"object\": {        \"url\": \"%2$s\",        \"title\": \"Page\"    }}".formatted(pageId, confluenceLink, this.appId)).retrieve().toBodilessEntity();
        log.info("Jira issue '{}' updated with confluence link '{}'", (Object)jiraIssueKey, (Object)confluenceLink);
    }

    @Override
    public Map<String, List<String>> searchIssuesLabels(Set<String> jiraIssueKeys) throws JiraIssuesNotFoundException {
        if (jiraIssueKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        String url = "/search";
        log.debug("Call jira api with url '{}' and jiraIssueKeys '{}'", (Object)"/search", jiraIssueKeys);
        String body = "{ \"jql\": \"key in (%1$s)\", \"fields\":[\"key\", \"labels\"] }";
        try {
            JiraSearchResultDto jiraSearchResultDto = (JiraSearchResultDto)((RestClient.RequestBodySpec)this.restClient.post().uri("/search", new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)"{ \"jql\": \"key in (%1$s)\", \"fields\":[\"key\", \"labels\"] }".formatted(String.join((CharSequence)",", jiraIssueKeys))).exchange((clientRequest, clientResponse) -> {
                if (clientResponse.getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.BAD_REQUEST)) {
                    throw this.mapToException((String)clientResponse.bodyTo(String.class));
                }
                return Objects.requireNonNull((JiraSearchResultDto)clientResponse.bodyTo(JiraSearchResultDto.class), "result of api call is null!");
            });
            log.trace("Received response {}", (Object)jiraSearchResultDto);
            Map<String, List<String>> issuesWithLabels = jiraSearchResultDto.getIssues().stream().collect(Collectors.toMap(JiraIssueDto::getKey, issue -> issue.getFields().getLabels()));
            log.debug("Received jira issues with labels '{}'", issuesWithLabels);
            return issuesWithLabels;
        }
        catch (Exception e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof JiraIssuesNotFoundException) {
                JiraIssuesNotFoundException jiraIssuesNotFoundException = (JiraIssuesNotFoundException)throwable;
                throw jiraIssuesNotFoundException;
            }
            throw e;
        }
    }

    private JiraIssuesNotFoundException mapToException(String errorMessageJson) {
        try {
            ArrayList<String> jiraIssues = new ArrayList<String>();
            for (String errorMessage : ((JiraErrorResponse)objectMapper.readValue(errorMessageJson, JiraErrorResponse.class)).getErrorMessages()) {
                Matcher matcher = pattern.matcher(errorMessage);
                if (!matcher.find()) continue;
                jiraIssues.add(matcher.group(1));
            }
            return new JiraIssuesNotFoundException(jiraIssues);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

