/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.persistence;

import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPage;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPageQueryResult;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;

public interface JpaDeploymentPageRepository
extends CrudRepository<DeploymentPage, UUID> {
    public Optional<DeploymentPage> findDeploymentPageByDeploymentId(UUID var1);

    @Query(value="select p from DeploymentPage p inner join Deployment d on p.deploymentId = d.id inner join ComponentVersion cv on d.componentVersion = cv inner join Component c on cv.component = c inner join System s on c.system = s where s.id = :systemId and d.environment in :envs order by p.deploymentStateTimestamp desc\n")
    public List<DeploymentPage> getDeploymentPagesForEnvironments(@Param(value="envs") List<Environment> var1, @Param(value="systemId") UUID var2);

    @Query(value="select new ch.admin.bit.jeap.deploymentlog.domain.DeploymentPageQueryResult(d.id, p.pageId) from DeploymentPage p inner join Deployment d on p.deploymentId = d.id inner join ComponentVersion cv on d.componentVersion = cv inner join Component c on cv.component = c inner join System s on c.system = s where s.id = :systemId and p.pageId is not null\n")
    public List<DeploymentPageQueryResult> getDeploymentPagesForSystem(@Param(value="systemId") UUID var1);
}

