/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.persistence;

import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
interface JpaDeploymentRepository
extends CrudRepository<Deployment, UUID> {
    public Optional<Deployment> findByExternalId(String var1);

    @Query(value="select d from Deployment d, ComponentVersion cv, Component c, System s, Environment e where e.id = :envId and s.id = :systemId and d.componentVersion.id = cv.id and cv.component.id = c.id and c.system.id = s.id and d.environment.id = e.id\n")
    public List<Deployment> findAllDeploymentForSystemAndEnv(@Param(value="envId") UUID var1, @Param(value="systemId") UUID var2);

    @Query(value="select d from Deployment d, ComponentVersion cv, Component c, System s where s.id = :systemId and d.componentVersion.id = cv.id and d.startedAt between :from and :to and cv.component.id = c.id and c.system.id = s.id\n")
    public List<Deployment> findAllDeploymentsForSystemStartedBetween(@Param(value="systemId") UUID var1, @Param(value="from") ZonedDateTime var2, @Param(value="to") ZonedDateTime var3);

    @Query(value="select d from Deployment d, ComponentVersion cv, Component c, System s, Environment e where e.id = :envId and s.id = :systemId and d.componentVersion.id = cv.id and cv.component.id = c.id and c.system.id = s.id and d.environment.id = e.id order by d.startedAt desc\n")
    public Page<Deployment> findDeploymentForSystemAndEnvLimited(@Param(value="envId") UUID var1, @Param(value="systemId") UUID var2, Pageable var3);

    @Query(value="select d from Deployment d, ComponentVersion cv, Component c, System s, Environment e where e.id = :envId and d.startedAt > :minStartedAt and d.componentVersion.id = cv.id and cv.component.id = c.id and c.system.id = s.id and d.environment.id = e.id order by d.startedAt desc\n")
    public Page<Deployment> findDeploymentForEnvLimited(@Param(value="envId") UUID var1, @Param(value="minStartedAt") ZonedDateTime var2, Pageable var3);

    @Query(value="select deployment.id from Deployment deployment left join DeploymentPage page on deployment.id = page.deploymentId where deployment.startedAt >= :from and deployment.startedAt <= :to and (page.id is null or deployment.lastModified > page.deploymentStateTimestamp)\n")
    public List<UUID> getDeploymentIdsMissingOrOutdatedGeneratedPages(@Param(value="from") ZonedDateTime var1, @Param(value="to") ZonedDateTime var2, Pageable var3);

    @Query(value="select count(deployment.id) from Deployment deployment left join DeploymentPage page on deployment.id = page.deploymentId where deployment.startedAt >= :from and (page.id is null or deployment.lastModified > page.deploymentStateTimestamp)\n")
    public long countDeploymentsWithMissingOrOutdatedGeneratedPages(@Param(value="from") ZonedDateTime var1);

    @Query(value="select d from Deployment d where d.componentVersion.component = :component and d.environment = :env order by d.startedAt desc\n")
    public List<Deployment> getLastDeploymentsForComponent(@Param(value="component") Component var1, @Param(value="env") Environment var2, Pageable var3);

    @Query(value="select d from Deployment d where d.componentVersion.component = :component and d.environment = :env and d.state = 'SUCCESS' order by d.startedAt desc\n")
    public List<Deployment> getLastSuccessfulDeploymentsForComponent(@Param(value="component") Component var1, @Param(value="env") Environment var2, Pageable var3);

    @Query(value="select d from Deployment d where d.componentVersion.component = :component and d.componentVersion.versionName <> :version and d.environment = :env and d.state = 'SUCCESS' order by d.startedAt desc\n")
    public List<Deployment> getSuccessfulDeploymentsForComponentDifferentToVersion(@Param(value="component") Component var1, @Param(value="env") Environment var2, @Param(value="version") String var3, Pageable var4);

    @Query(value="select s.name from Deployment d, ComponentVersion cv, Component c, System s where d.id = :deploymentId and cv = d.componentVersion and c = cv.component and s = c.system\n")
    public String getSystemNameForDeployment(@Param(value="deploymentId") UUID var1);
}

