/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.persistence;

import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.System;
import ch.admin.bit.jeap.deploymentlog.persistence.JpaDeploymentRepository;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@org.springframework.stereotype.Component
public class DeploymentRepositoryImpl
implements DeploymentRepository {
    private final JpaDeploymentRepository jpaDeploymentRepository;

    public Deployment save(Deployment deployment) {
        return (Deployment)this.jpaDeploymentRepository.save(deployment);
    }

    public Deployment getById(UUID id) {
        return (Deployment)this.jpaDeploymentRepository.findById(id).orElseThrow();
    }

    public Optional<Deployment> findById(UUID id) {
        return this.jpaDeploymentRepository.findById(id);
    }

    public Optional<Deployment> findByExternalId(String externalId) {
        return this.jpaDeploymentRepository.findByExternalId(externalId);
    }

    public List<Deployment> findAllDeploymentForSystemAndEnv(System system, Environment environment) {
        return this.jpaDeploymentRepository.findAllDeploymentForSystemAndEnv(environment.getId(), system.getId());
    }

    public List<Deployment> findAllDeploymentsForSystemStartedBetween(System system, ZonedDateTime from, ZonedDateTime to) {
        return this.jpaDeploymentRepository.findAllDeploymentsForSystemStartedBetween(system.getId(), from, to);
    }

    public List<Integer> findAllDeploymentsYearsForSystemAndEnv(System system, Environment environment) {
        return this.jpaDeploymentRepository.findAllDeploymentForSystemAndEnv(environment.getId(), system.getId()).stream().map(deployment -> deployment.getStartedAt().getYear()).distinct().toList();
    }

    public List<Deployment> findDeploymentForSystemAndEnvLimited(System system, Environment environment, int limit) {
        PageRequest pageable = PageRequest.of((int)0, (int)limit);
        Page<Deployment> deploymentPage = this.jpaDeploymentRepository.findDeploymentForSystemAndEnvLimited(environment.getId(), system.getId(), (Pageable)pageable);
        return deploymentPage.stream().toList();
    }

    public List<Deployment> findDeploymentForEnvLimited(Environment environment, ZonedDateTime minStartedAt, int limit) {
        PageRequest pageable = PageRequest.of((int)0, (int)limit);
        Page<Deployment> deploymentPage = this.jpaDeploymentRepository.findDeploymentForEnvLimited(environment.getId(), minStartedAt, (Pageable)pageable);
        return deploymentPage.stream().toList();
    }

    public List<UUID> getDeploymentIdsWithMissingOrOutdatedGeneratedPages(int limit, ZonedDateTime from, ZonedDateTime to) {
        PageRequest pageable = PageRequest.of((int)0, (int)limit, (Sort)Sort.by((String[])new String[]{"lastModified"}).descending());
        return this.jpaDeploymentRepository.getDeploymentIdsMissingOrOutdatedGeneratedPages(from, to, (Pageable)pageable);
    }

    public long countDeploymentsWithMissingOrOutdatedGeneratedPages(ZonedDateTime from) {
        return this.jpaDeploymentRepository.countDeploymentsWithMissingOrOutdatedGeneratedPages(from);
    }

    public Optional<Deployment> getLastDeploymentForComponent(Component component, Environment env) {
        List<Deployment> results = this.jpaDeploymentRepository.getLastDeploymentsForComponent(component, env, (Pageable)PageRequest.of((int)0, (int)1));
        return results.stream().findFirst();
    }

    public Optional<Deployment> getLastSuccessfulDeploymentForComponent(Component component, Environment env) {
        List<Deployment> results = this.jpaDeploymentRepository.getLastSuccessfulDeploymentsForComponent(component, env, (Pageable)PageRequest.of((int)0, (int)1));
        return results.stream().findFirst();
    }

    public Optional<Deployment> getLastSuccessfulDeploymentForComponentDifferentToVersion(Component component, Environment env, String version) {
        List<Deployment> results = this.jpaDeploymentRepository.getSuccessfulDeploymentsForComponentDifferentToVersion(component, env, version, (Pageable)PageRequest.of((int)0, (int)1));
        return results.stream().findFirst();
    }

    public String getSystemNameForDeployment(UUID deploymentId) {
        return this.jpaDeploymentRepository.getSystemNameForDeployment(deploymentId);
    }

    @Generated
    public DeploymentRepositoryImpl(JpaDeploymentRepository jpaDeploymentRepository) {
        this.jpaDeploymentRepository = jpaDeploymentRepository;
    }
}

