/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.persistence;

import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.System;
import ch.admin.bit.jeap.deploymentlog.persistence.JpaEnvironmentRepository;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentRepositoryImpl
implements EnvironmentRepository {
    private final JpaEnvironmentRepository jpaEnvironmentRepository;

    public Environment getById(UUID envId) {
        return (Environment)this.jpaEnvironmentRepository.findById(envId).orElseThrow();
    }

    public Optional<Environment> findByName(String name) {
        return this.jpaEnvironmentRepository.findByName(name);
    }

    public Environment save(Environment environment) {
        return (Environment)this.jpaEnvironmentRepository.save(environment);
    }

    public List<Environment> findEnvironmentsForSystem(System system) {
        return this.jpaEnvironmentRepository.findEnvironmentsForSystem(system.getId());
    }

    public List<Environment> findNonProductiveEnvironmentsForSystemId(UUID systemId) {
        return this.jpaEnvironmentRepository.findEnvironmentsForSystem(systemId).stream().filter(env -> !env.isProductive()).toList();
    }

    public Iterable<Environment> findAll() {
        return this.jpaEnvironmentRepository.findAll();
    }

    @Generated
    public EnvironmentRepositoryImpl(JpaEnvironmentRepository jpaEnvironmentRepository) {
        this.jpaEnvironmentRepository = jpaEnvironmentRepository;
    }
}

