/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.persistence;

import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.ComponentVersionSummary;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionState;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface JpaEnvironmentComponentVersionStateRepository
extends CrudRepository<EnvironmentComponentVersionState, UUID> {
    @Query(value="select distinct c from EnvironmentComponentVersionState ecvs, Component c, System s where ecvs.component.id = c.id and c.system.id = s.id and s.id = :systemId\n")
    public List<Component> findComponentsBySystemId(@Param(value="systemId") UUID var1);

    public Optional<EnvironmentComponentVersionState> findByEnvironmentAndComponent(Environment var1, Component var2);

    public List<EnvironmentComponentVersionState> findByComponentIn(Set<Component> var1);

    public void deleteByComponentEqualsAndEnvironmentEquals(Component var1, Environment var2);

    @Query(nativeQuery=true, value="select c.name as componentName, cv.version_name as version from environment_component_version_state ecvs inner join component_version cv on cv.id = ecvs.component_version_id inner join component c ON c.id = ecvs.component_id where ecvs.environment_id = :environmentId\n")
    public List<ComponentVersionSummary> getDeployedComponentsOnEnvironment(@Param(value="environmentId") UUID var1);
}

