/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.deploymentlog.domain.ArtifactVersionService;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.ArtifactVersionCreateDto;
import io.swagger.v3.oas.annotations.Operation;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/artifact-version"})
public class ArtifactVersionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArtifactVersionController.class);
    private final ArtifactVersionService artifactVersionService;

    @PutMapping(value={"/{id}"})
    @Operation(summary="Save new artifact version")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public ResponseEntity<Void> save(@PathVariable(name="id") String artifactVersionId, @RequestBody ArtifactVersionCreateDto artifactVersionCreateDto) {
        log.debug("Save new artifactVersion with artifactVersionId '{}', coordinates '{}' and buildJobLink '{}'", new Object[]{artifactVersionId, artifactVersionCreateDto.getCoordinates(), artifactVersionCreateDto.getBuildJobLink()});
        UUID artefactVersionUuid = UUID.fromString(artifactVersionId);
        if (this.artifactVersionService.findById(artefactVersionUuid).isPresent()) {
            log.info("ArtifactVersion with id {} already exists. Returning OK", (Object)artifactVersionId);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        this.artifactVersionService.saveArtifactVersion(artefactVersionUuid, artifactVersionCreateDto.getCoordinates(), artifactVersionCreateDto.getBuildJobLink());
        log.info("ArtifactVersion with id {} saved. Returning CREATED", (Object)artifactVersionId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }

    @Generated
    public ArtifactVersionController(ArtifactVersionService artifactVersionService) {
        this.artifactVersionService = artifactVersionService;
    }
}

