/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.deploymentlog.domain.exception.AliasNameAlreadyDefinedException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.ComponentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.DeploymentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.DeploymentPageNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.EnvironmentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.InvalidDeploymentStateForUpdateException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.SystemNameAlreadyDefinedException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.SystemNotFoundException;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.client.RestClientResponseException;

@RestControllerAdvice
public class RestResponseExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestResponseExceptionHandler.class);

    @ExceptionHandler(value={DeploymentNotFoundException.class})
    public ResponseEntity<String> handleDeploymentNotFoundException(DeploymentNotFoundException ex) {
        log.warn(ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InvalidDeploymentStateForUpdateException.class})
    public ResponseEntity<String> handleInvalidDeploymentStateForUpdateException(InvalidDeploymentStateForUpdateException ex) {
        log.warn(ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={SystemNotFoundException.class})
    public ResponseEntity<String> handleSystemNotFoundException(SystemNotFoundException ex) {
        log.warn(ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={EnvironmentNotFoundException.class})
    public ResponseEntity<String> handleEnvironmentNotFoundException(EnvironmentNotFoundException ex) {
        log.warn(ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ComponentNotFoundException.class})
    public ResponseEntity<String> handleComponentNotFoundException(ComponentNotFoundException ex) {
        log.warn(ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={DeploymentPageNotFoundException.class})
    public ResponseEntity<String> handleDeploymentPageNotFoundException(DeploymentPageNotFoundException ex) {
        log.warn(ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={RestClientResponseException.class})
    public ResponseEntity<String> handleRestClientResponseException(RestClientResponseException ex) {
        String errorSummary = "Rest client request failed: %s %s %s %s".formatted(ex.getStatusCode().value(), ex.getStatusText(), ex.getMessage(), ex.getResponseBodyAsString(StandardCharsets.UTF_8));
        log.warn(errorSummary, (Throwable)ex);
        return new ResponseEntity((Object)errorSummary, ex.getStatusCode());
    }

    @ExceptionHandler(value={AliasNameAlreadyDefinedException.class})
    public ResponseEntity<String> handleAliasAlreadyDefinedException(AliasNameAlreadyDefinedException ex) {
        log.warn(ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={SystemNameAlreadyDefinedException.class})
    public ResponseEntity<String> handleSystemNameAlreadyDefinedException(SystemNameAlreadyDefinedException ex) {
        log.warn(ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

