/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.db.tx.TransactionalReadReplica;
import ch.admin.bit.jeap.deploymentlog.docgen.service.DocgenAsyncService;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentService;
import ch.admin.bit.jeap.deploymentlog.domain.exception.DeploymentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.InvalidDeploymentStateForUpdateException;
import ch.admin.bit.jeap.deploymentlog.jira.JiraIssuesNotFoundException;
import ch.admin.bit.jeap.deploymentlog.web.api.DeploymentCheckService;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentCheckResult;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentCreateDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentCreateResultDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentUpdateStateDto;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/deployment"})
public class DeploymentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploymentController.class);
    private final DeploymentService deploymentService;
    private final DocgenAsyncService docgenAsyncService;
    private final DeploymentCheckService deploymentCheckService;

    @PutMapping(value={"/{id}"})
    @Operation(summary="Create a new deployment")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public ResponseEntity<DeploymentCreateResultDto> createDeployment(@PathVariable(name="id") String externalId, @RequestParam(required=false) boolean readyForDeployCheck, @RequestBody DeploymentCreateDto deploymentCreateDto) throws JiraIssuesNotFoundException {
        log.debug("Create new deployment with externalId '{}' for the component '{}' of the system '{}' on env '{}'", new Object[]{externalId, deploymentCreateDto.getComponentVersion().getComponentName(), deploymentCreateDto.getComponentVersion().getSystemName(), deploymentCreateDto.getEnvironmentName()});
        if (this.deploymentService.findByExternalId(externalId).isPresent()) {
            log.info("Deployment with externalId {} already exists. Returning OK", (Object)externalId);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        DeploymentCreateResultDto deploymentCreateResultDto = null;
        String changelogComment = null;
        String changelogComparedToVersion = null;
        Set<String> changelogJiraIssueKeys = null;
        if (deploymentCreateDto.getChangelog() != null) {
            changelogComparedToVersion = deploymentCreateDto.getChangelog().getComparedToVersion();
            changelogComment = deploymentCreateDto.getChangelog().getComment();
            changelogJiraIssueKeys = deploymentCreateDto.getChangelog().getJiraIssueKeys();
            if (readyForDeployCheck) {
                log.info("Check if the issues '{}' are ready to be deployed", changelogJiraIssueKeys);
                deploymentCreateResultDto = DeploymentCreateResultDto.builder().checkResult(this.deploymentCheckService.issuesReadyForDeploy(changelogJiraIssueKeys)).build();
                if (deploymentCreateResultDto.getCheckResult().getResult().equals((Object)DeploymentCheckResult.NOK)) {
                    log.info("Result of readyForDeployCheck is {}: returning bad request", (Object)deploymentCreateResultDto.getCheckResult().getResult());
                    return ResponseEntity.ok().body((Object)deploymentCreateResultDto);
                }
            }
        }
        UUID deploymentId = this.deploymentService.createDeployment(externalId, deploymentCreateDto.getComponentVersion().getVersionName(), deploymentCreateDto.getComponentVersion().getTaggedAt(), deploymentCreateDto.getComponentVersion().getVersionControlUrl(), deploymentCreateDto.getComponentVersion().getCommitRef(), deploymentCreateDto.getComponentVersion().getCommitedAt(), deploymentCreateDto.getComponentVersion().isPublishedVersion(), deploymentCreateDto.getComponentVersion().getSystemName(), deploymentCreateDto.getComponentVersion().getComponentName(), deploymentCreateDto.getEnvironmentName(), deploymentCreateDto.getTarget(), deploymentCreateDto.getStartedAt(), deploymentCreateDto.getStartedBy(), deploymentCreateDto.getDeploymentUnit(), deploymentCreateDto.getLinks(), deploymentCreateDto.getProperties(), deploymentCreateDto.getReferenceIdentifiers(), changelogComment, changelogComparedToVersion, changelogJiraIssueKeys, deploymentCreateDto.getRemedyChangeId(), deploymentCreateDto.getDeploymentTypes());
        this.triggerDocgenForDeployment(deploymentId);
        if (deploymentCreateResultDto == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)deploymentCreateResultDto);
    }

    private void triggerDocgenForDeployment(UUID deploymentId) {
        try {
            this.docgenAsyncService.triggerDocgenForDeployment(deploymentId);
        }
        catch (Exception ex) {
            log.error("Failed to trigger docgen for deployment {} - will re-attempt generation in scheduled task", (Object)StructuredArguments.value((String)"deploymentId", (Object)deploymentId), (Object)ex);
        }
    }

    @PutMapping(value={"/{id}/state"})
    @Operation(summary="Update the state of an existing deployment")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public void updateState(@PathVariable(name="id") String externalId, @RequestBody DeploymentUpdateStateDto deploymentUpdateStateDto) throws DeploymentNotFoundException, InvalidDeploymentStateForUpdateException {
        log.debug("Update the deployment with externalId '{}' with the new state '{}'", (Object)externalId, (Object)deploymentUpdateStateDto.getState());
        UUID deploymentId = this.deploymentService.updateState(externalId, deploymentUpdateStateDto.getState(), deploymentUpdateStateDto.getMessage(), deploymentUpdateStateDto.getTimestamp(), deploymentUpdateStateDto.getProperties());
        this.triggerDocgenForDeployment(deploymentId);
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get deployment information")
    @PreAuthorize(value="hasAnyRole('deploymentlog-read','deploymentlog-write')")
    @TransactionalReadReplica
    public DeploymentDto getDeployment(@PathVariable(name="id") String externalId) throws DeploymentNotFoundException {
        log.debug("Retrieve the deployment with externalId '{}'", (Object)externalId);
        return DeploymentDto.of(this.deploymentService.getDeployment(externalId));
    }

    @Generated
    public DeploymentController(DeploymentService deploymentService, DocgenAsyncService docgenAsyncService, DeploymentCheckService deploymentCheckService) {
        this.deploymentService = deploymentService;
        this.docgenAsyncService = docgenAsyncService;
        this.deploymentCheckService = deploymentCheckService;
    }
}

