/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.deploymentlog.domain.DeploymentPage;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentService;
import ch.admin.bit.jeap.deploymentlog.domain.exception.DeploymentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.DeploymentPageNotFoundException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/deployment-doc"})
public class DeploymentDocController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploymentDocController.class);
    private final DeploymentService deploymentService;
    @Value(value="${jeap.deploymentlog.documentation.root-url}")
    private String documentationRootUrl;

    @ApiResponses(value={@ApiResponse(responseCode="302", description="Redirects to documentation")})
    @Operation(summary="Redirect to the deployment page")
    @GetMapping(value={"/{id}"})
    public void redirectToDeploymentPage(@PathVariable(name="id") String externalId, HttpServletResponse httpServletResponse) throws DeploymentNotFoundException, DeploymentPageNotFoundException {
        log.debug("Retrieve the deployment page for the deployment with externalId '{}'", (Object)externalId);
        DeploymentPage deploymentPage = this.deploymentService.getDeploymentPage(externalId);
        log.info("Redirect for deployment with externalId {} to deployment page {}", (Object)externalId, (Object)deploymentPage.getPageId());
        httpServletResponse.setHeader("Location", this.documentationRootUrl + deploymentPage.getPageId());
        httpServletResponse.setStatus(HttpStatus.FOUND.value());
    }

    @Generated
    public DeploymentDocController(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }
}

