/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.db.tx.TransactionalReadReplica;
import ch.admin.bit.jeap.deploymentlog.docgen.service.DocgenAsyncService;
import ch.admin.bit.jeap.deploymentlog.domain.Component;
import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentService;
import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionState;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionStateRepository;
import ch.admin.bit.jeap.deploymentlog.domain.System;
import ch.admin.bit.jeap.deploymentlog.domain.SystemService;
import ch.admin.bit.jeap.deploymentlog.domain.exception.AliasNameAlreadyDefinedException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.ComponentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.EnvironmentNotFoundException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.SystemNameAlreadyDefinedException;
import ch.admin.bit.jeap.deploymentlog.domain.exception.SystemNotFoundException;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.ComponentSnapshotDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentSnapshotDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.EnvironmentComponentVersionStateDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.UndeploymentCreateDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/system"})
public class SystemController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    private final EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository;
    private final SystemService systemService;
    private final DeploymentService deploymentService;
    private final DocgenAsyncService docgenAsyncService;

    @GetMapping(value={"/{systemName}"})
    @Operation(summary="Get all the latest deployments for the system")
    @TransactionalReadReplica
    @PreAuthorize(value="hasAnyRole('deploymentlog-read','deploymentlog-write')")
    public EnvironmentComponentVersionStateDto getSystem(@PathVariable String systemName) throws SystemNotFoundException {
        log.debug("Get all the latest deployments for the system with name '{}'", (Object)systemName);
        System system = this.systemService.retrieveSystemByName(systemName);
        List environmentComponentVersionStates = this.environmentComponentVersionStateRepository.findByComponentIn(system.getComponents());
        Map<String, List<EnvironmentComponentVersionState>> deploymentsGroupedByComponent = environmentComponentVersionStates.stream().collect(Collectors.groupingBy(e -> e.getComponent().getName()));
        ArrayList<ComponentSnapshotDto> components = new ArrayList<ComponentSnapshotDto>();
        deploymentsGroupedByComponent.forEach((componentName, deployments) -> components.add(ComponentSnapshotDto.builder().name((String)componentName).deployments(DeploymentSnapshotDto.of(deployments)).build()));
        return EnvironmentComponentVersionStateDto.builder().systemName(systemName).components(components).build();
    }

    @PutMapping(value={"/{id}/undeploy"})
    @Operation(summary="Delete the component of the system")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    @Transactional
    public void deleteComponent(@PathVariable(name="id") String externalId, @RequestBody UndeploymentCreateDto undeploymentCreateDto) throws SystemNotFoundException, EnvironmentNotFoundException, ComponentNotFoundException {
        String componentName = undeploymentCreateDto.getComponentName();
        String systemName = undeploymentCreateDto.getSystemName();
        String environmentName = undeploymentCreateDto.getEnvironmentName();
        Component component = this.systemService.retrieveComponentByName(systemName, componentName);
        Environment environment = this.systemService.retrieveEnvironmentByName(environmentName);
        Deployment previousDeployment = this.deploymentService.getLastDeploymentForComponent(component, environment);
        log.debug("Delete the component '{}' from system '{}' on environment '{}'", new Object[]{componentName, systemName, environmentName});
        this.systemService.deleteComponent(systemName, componentName, environmentName);
        UUID undeploymentId = this.deploymentService.createUndeployment(previousDeployment, externalId, systemName, componentName, environmentName, undeploymentCreateDto.getStartedAt(), undeploymentCreateDto.getStartedBy(), undeploymentCreateDto.getRemedyChangeId());
        this.triggerDocgenForUndeployment(systemName, undeploymentId);
    }

    @GetMapping(value={"/{systemName}/component/{componentName}/currentVersion/{environment}"}, produces={"text/plain"})
    @Operation(summary="Get current version of component of system on environment")
    @ApiResponses(value={@ApiResponse(responseCode="404", description="System, component or environment not found, or no version deployed on env at the moment")})
    @PreAuthorize(value="hasAnyRole('deploymentlog-read','deploymentlog-write')")
    public String getCurrentComponentVersionOnEnvironment(@PathVariable String systemName, @PathVariable String componentName, @PathVariable String environment) throws SystemNotFoundException, EnvironmentNotFoundException, ComponentNotFoundException {
        log.debug("Get the version of component '{}' of system '{}' on environment '{}'", new Object[]{componentName, systemName, environment});
        return (String)this.systemService.getCurrentVersionOfComponent(systemName, componentName, environment).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{systemName}/component/{componentName}/previousVersion/{environment}"}, produces={"text/plain"})
    @Operation(summary="Get previous version of component of system on environment that is different to the version param")
    @ApiResponses(value={@ApiResponse(responseCode="404", description="System, component or environment not found, or no version deployed on env at the moment")})
    @PreAuthorize(value="hasAnyRole('deploymentlog-read','deploymentlog-write')")
    public String getPreviousComponentVersionOnEnvironment(@PathVariable String systemName, @PathVariable String componentName, @PathVariable String environment, @RequestParam String version) throws SystemNotFoundException, EnvironmentNotFoundException, ComponentNotFoundException {
        log.debug("Get the previous version of '{}' of component '{}' of system '{}' on environment '{}'", new Object[]{version, componentName, systemName, environment});
        return (String)this.systemService.getPreviousVersionOfComponent(systemName, componentName, environment, version).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/{systemName}/component/{componentName}/previousDeployment/{environment}"})
    @Operation(summary="Get previous deployment of component of system on environment that is different to the version param")
    @ApiResponses(value={@ApiResponse(responseCode="404", description="System, component or environment not found, or no version deployed on env at the moment")})
    @PreAuthorize(value="hasAnyRole('deploymentlog-read','deploymentlog-write')")
    @TransactionalReadReplica
    public DeploymentDto getPreviousComponentDeploymentOnEnvironment(@PathVariable String systemName, @PathVariable String componentName, @PathVariable String environment, @RequestParam String version) throws SystemNotFoundException, EnvironmentNotFoundException, ComponentNotFoundException {
        log.debug("Get the previous deployment of '{}' of component '{}' of system '{}' on environment '{}'", new Object[]{version, componentName, systemName, environment});
        Deployment deployment = (Deployment)this.systemService.getPreviousDeploymentOfComponent(systemName, componentName, environment, version).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        return DeploymentDto.of(deployment);
    }

    @PostMapping(value={"/{systemName}/alias/{aliasName}"})
    @Operation(summary="Create a new alias for a system")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    @Transactional
    public ResponseEntity<Void> createAlias(@PathVariable(name="systemName") String systemName, @PathVariable(name="aliasName") String aliasName) throws SystemNotFoundException, AliasNameAlreadyDefinedException, SystemNameAlreadyDefinedException {
        log.info("Create new alias '{}' for system '{}'", (Object)aliasName, (Object)systemName);
        this.systemService.createAlias(systemName, aliasName);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @PostMapping(value={"/{oldSystemName}/migrate-to/{newSystemName}"})
    @Operation(summary="Update the name of the system and create a new alias with the old name")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    @Transactional
    public ResponseEntity<Void> migrateFromAlias(@PathVariable(name="oldSystemName") String oldSystemName, @PathVariable(name="newSystemName") String newSystemName) throws SystemNotFoundException, AliasNameAlreadyDefinedException, SystemNameAlreadyDefinedException {
        log.info("Updating system '{}' with new name '{}'", (Object)oldSystemName, (Object)newSystemName);
        System system = this.systemService.updateSystemName(oldSystemName, newSystemName);
        this.docgenAsyncService.triggerMigrationForSystem(system);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @PostMapping(value={"/{systemName}/merge-from/{oldSystemName}"})
    @Operation(summary="Merge the second system into the first system and create a new alias with the second system name")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    @Transactional
    public ResponseEntity<Void> mergeSystem(@PathVariable(name="systemName") String systemName, @PathVariable(name="oldSystemName") String oldSystemName) throws SystemNotFoundException {
        log.info("Merging system '{}' into '{}'", (Object)oldSystemName, (Object)systemName);
        System system = this.systemService.retrieveSystemByName(systemName);
        System oldSystem = this.systemService.retrieveSystemByName(oldSystemName);
        if (system.getId().equals(oldSystem.getId())) {
            log.warn("Cannot merge system into itself");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        this.docgenAsyncService.triggerMergeSystems(system, oldSystem);
        this.systemService.mergeSystems(system, oldSystem);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).build();
    }

    private void triggerDocgenForUndeployment(String systemName, UUID deploymentId) {
        try {
            this.docgenAsyncService.triggerDocgenForUndeployment(systemName, deploymentId);
        }
        catch (Exception ex) {
            log.error("Failed to trigger docgen for undeployment {} - will re-attempt generation in scheduled task", (Object)StructuredArguments.value((String)"deploymentId", (Object)deploymentId), (Object)ex);
        }
    }

    @Generated
    public SystemController(EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository, SystemService systemService, DeploymentService deploymentService, DocgenAsyncService docgenAsyncService) {
        this.environmentComponentVersionStateRepository = environmentComponentVersionStateRepository;
        this.systemService = systemService;
        this.deploymentService = deploymentService;
        this.docgenAsyncService = docgenAsyncService;
    }
}

