/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.deploymentlog.docgen.DocumentationGenerator;
import ch.admin.bit.jeap.deploymentlog.docgen.service.DocgenAsyncService;
import ch.admin.bit.jeap.deploymentlog.docgen.service.SchedulingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jobs"})
public class JobsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobsController.class);
    private final DocumentationGenerator documentationGenerator;
    private final SchedulingService schedulingService;
    private final DocgenAsyncService docgenAsyncService;

    @PostMapping(value={"/docgen"})
    @Operation(summary="Regenerate all Confluence Pages. For Testing/Developing only!")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public ResponseEntity<Void> generateDocumentation() {
        this.documentationGenerator.generateAllPages();
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/docgen/system/{systemName}"})
    @Operation(summary="Regenerate all confluence pages for a system")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public ResponseEntity<Void> generateDocumentationForSystem(@PathVariable(value="systemName") String systemName, @RequestParam(name="year", required=false) Integer year) {
        this.docgenAsyncService.triggerDocgenForSystem(systemName, year);
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/docgen/deployment/{deploymentId}"})
    @Operation(summary="(Re)generate a page for a single deployment")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public ResponseEntity<Void> generateDeploymentPage(@PathVariable UUID deploymentId) {
        this.docgenAsyncService.triggerDocgenForDeployment(deploymentId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }

    @PostMapping(value={"/outdatedPageHousekeeping"})
    @Operation(summary="Clean up outdated pages")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public ResponseEntity<Void> outdatedPageHousekeeping() {
        this.schedulingService.outdatedPageHousekeeping();
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/docgen/system/{systemName}/repairJiraLinks"})
    @Operation(summary="Regenerate for a system all jira links of deployments started between the given dates", parameters={@Parameter(name="from", description="Start date (incl) (format: yyyy-MM-dd)", required=true, example="2025-01-01"), @Parameter(name="to", description="End date (excl) (format: yyyy-MM-dd)", required=true, example="2025-01-20")})
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public ResponseEntity<Void> generateJiraLinksForSystem(@PathVariable(value="systemName") String systemName, @RequestParam(value="from") String from, @RequestParam(value="to") String to) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        this.docgenAsyncService.triggerGenerateJiraLinksForSystem(systemName, LocalDate.parse(from, dateTimeFormatter).atStartOfDay(ZoneId.systemDefault()), LocalDate.parse(to, dateTimeFormatter).atStartOfDay(ZoneId.systemDefault()));
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Generated
    public JobsController(DocumentationGenerator documentationGenerator, SchedulingService schedulingService, DocgenAsyncService docgenAsyncService) {
        this.documentationGenerator = documentationGenerator;
        this.schedulingService = schedulingService;
        this.docgenAsyncService = docgenAsyncService;
    }
}

