/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api.dto;

import ch.admin.bit.jeap.deploymentlog.domain.Deployment;
import ch.admin.bit.jeap.deploymentlog.domain.DeploymentState;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.ComponentVersionDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.EnvironmentDto;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.LinkDto;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import lombok.Generated;

public final class DeploymentDto {
    private final UUID id;
    private final String externalId;
    private final ZonedDateTime startedAt;
    private final ZonedDateTime endedAt;
    private final DeploymentState state;
    private final String startedBy;
    private final EnvironmentDto environment;
    private final ComponentVersionDto componentVersion;
    private final Set<LinkDto> links;
    private final Map<String, String> properties;

    public static DeploymentDto of(Deployment deployment) {
        return DeploymentDto.builder().id(deployment.getId()).externalId(deployment.getExternalId()).startedAt(deployment.getStartedAt()).endedAt(deployment.getEndedAt()).state(deployment.getState()).startedBy(deployment.getStartedBy()).environment(EnvironmentDto.of(deployment.getEnvironment())).componentVersion(ComponentVersionDto.of(deployment.getComponentVersion())).links(LinkDto.allOf(deployment.getLinks())).properties(new TreeMap<String, String>(deployment.getProperties())).build();
    }

    @ConstructorProperties(value={"id", "externalId", "startedAt", "endedAt", "state", "startedBy", "environment", "componentVersion", "links", "properties"})
    @Generated
    DeploymentDto(UUID id, String externalId, ZonedDateTime startedAt, ZonedDateTime endedAt, DeploymentState state, String startedBy, EnvironmentDto environment, ComponentVersionDto componentVersion, Set<LinkDto> links, Map<String, String> properties) {
        this.id = id;
        this.externalId = externalId;
        this.startedAt = startedAt;
        this.endedAt = endedAt;
        this.state = state;
        this.startedBy = startedBy;
        this.environment = environment;
        this.componentVersion = componentVersion;
        this.links = links;
        this.properties = properties;
    }

    @Generated
    public static DeploymentDtoBuilder builder() {
        return new DeploymentDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getExternalId() {
        return this.externalId;
    }

    @Generated
    public ZonedDateTime getStartedAt() {
        return this.startedAt;
    }

    @Generated
    public ZonedDateTime getEndedAt() {
        return this.endedAt;
    }

    @Generated
    public DeploymentState getState() {
        return this.state;
    }

    @Generated
    public String getStartedBy() {
        return this.startedBy;
    }

    @Generated
    public EnvironmentDto getEnvironment() {
        return this.environment;
    }

    @Generated
    public ComponentVersionDto getComponentVersion() {
        return this.componentVersion;
    }

    @Generated
    public Set<LinkDto> getLinks() {
        return this.links;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeploymentDto)) {
            return false;
        }
        DeploymentDto other = (DeploymentDto)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        ZonedDateTime this$startedAt = this.getStartedAt();
        ZonedDateTime other$startedAt = other.getStartedAt();
        if (this$startedAt == null ? other$startedAt != null : !((Object)this$startedAt).equals(other$startedAt)) {
            return false;
        }
        ZonedDateTime this$endedAt = this.getEndedAt();
        ZonedDateTime other$endedAt = other.getEndedAt();
        if (this$endedAt == null ? other$endedAt != null : !((Object)this$endedAt).equals(other$endedAt)) {
            return false;
        }
        DeploymentState this$state = this.getState();
        DeploymentState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$startedBy = this.getStartedBy();
        String other$startedBy = other.getStartedBy();
        if (this$startedBy == null ? other$startedBy != null : !this$startedBy.equals(other$startedBy)) {
            return false;
        }
        EnvironmentDto this$environment = this.getEnvironment();
        EnvironmentDto other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        ComponentVersionDto this$componentVersion = this.getComponentVersion();
        ComponentVersionDto other$componentVersion = other.getComponentVersion();
        if (this$componentVersion == null ? other$componentVersion != null : !((Object)this$componentVersion).equals(other$componentVersion)) {
            return false;
        }
        Set<LinkDto> this$links = this.getLinks();
        Set<LinkDto> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        ZonedDateTime $startedAt = this.getStartedAt();
        result = result * 59 + ($startedAt == null ? 43 : ((Object)$startedAt).hashCode());
        ZonedDateTime $endedAt = this.getEndedAt();
        result = result * 59 + ($endedAt == null ? 43 : ((Object)$endedAt).hashCode());
        DeploymentState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $startedBy = this.getStartedBy();
        result = result * 59 + ($startedBy == null ? 43 : $startedBy.hashCode());
        EnvironmentDto $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        ComponentVersionDto $componentVersion = this.getComponentVersion();
        result = result * 59 + ($componentVersion == null ? 43 : ((Object)$componentVersion).hashCode());
        Set<LinkDto> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeploymentDto(id=" + String.valueOf(this.getId()) + ", externalId=" + this.getExternalId() + ", startedAt=" + String.valueOf(this.getStartedAt()) + ", endedAt=" + String.valueOf(this.getEndedAt()) + ", state=" + String.valueOf(this.getState()) + ", startedBy=" + this.getStartedBy() + ", environment=" + String.valueOf(this.getEnvironment()) + ", componentVersion=" + String.valueOf(this.getComponentVersion()) + ", links=" + String.valueOf(this.getLinks()) + ", properties=" + String.valueOf(this.getProperties()) + ")";
    }

    @Generated
    public static class DeploymentDtoBuilder {
        @Generated
        private UUID id;
        @Generated
        private String externalId;
        @Generated
        private ZonedDateTime startedAt;
        @Generated
        private ZonedDateTime endedAt;
        @Generated
        private DeploymentState state;
        @Generated
        private String startedBy;
        @Generated
        private EnvironmentDto environment;
        @Generated
        private ComponentVersionDto componentVersion;
        @Generated
        private Set<LinkDto> links;
        @Generated
        private Map<String, String> properties;

        @Generated
        DeploymentDtoBuilder() {
        }

        @Generated
        public DeploymentDtoBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder startedAt(ZonedDateTime startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder endedAt(ZonedDateTime endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder state(DeploymentState state) {
            this.state = state;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder environment(EnvironmentDto environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder componentVersion(ComponentVersionDto componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder links(Set<LinkDto> links) {
            this.links = links;
            return this;
        }

        @Generated
        public DeploymentDtoBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public DeploymentDto build() {
            return new DeploymentDto(this.id, this.externalId, this.startedAt, this.endedAt, this.state, this.startedBy, this.environment, this.componentVersion, this.links, this.properties);
        }

        @Generated
        public String toString() {
            return "DeploymentDto.DeploymentDtoBuilder(id=" + String.valueOf(this.id) + ", externalId=" + this.externalId + ", startedAt=" + String.valueOf(this.startedAt) + ", endedAt=" + String.valueOf(this.endedAt) + ", state=" + String.valueOf(this.state) + ", startedBy=" + this.startedBy + ", environment=" + String.valueOf(this.environment) + ", componentVersion=" + String.valueOf(this.componentVersion) + ", links=" + String.valueOf(this.links) + ", properties=" + String.valueOf(this.properties) + ")";
        }
    }
}

