/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.deploymentlog.jira.JiraIssuesNotFoundException;
import ch.admin.bit.jeap.deploymentlog.jira.JiraWebClient;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentCheckResult;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.DeploymentCheckResultDto;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeploymentCheckService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploymentCheckService.class);
    private final JiraWebClient jiraWebClient;
    public static final String R4DEPLOY_LABEL = "R4DEPLOY";

    public DeploymentCheckResultDto issuesReadyForDeploy(Set<String> issues) throws JiraIssuesNotFoundException {
        try {
            return this.checkIssues(issues, List.of());
        }
        catch (JiraIssuesNotFoundException issuesNotFoundException) {
            return this.ignoreUnknownJiraIssues(issues, issuesNotFoundException.getIssues());
        }
    }

    private DeploymentCheckResultDto ignoreUnknownJiraIssues(Set<String> issues, List<String> unknownIssues) throws JiraIssuesNotFoundException {
        unknownIssues.forEach(issues::remove);
        return this.checkIssues(issues, unknownIssues);
    }

    private DeploymentCheckResultDto checkIssues(Set<String> issues, List<String> unknownIssues) throws JiraIssuesNotFoundException {
        log.info("Check if the issues '{}' are ready to be deployed", issues);
        Map foundIssues = this.jiraWebClient.searchIssuesLabels(issues);
        HashSet<String> issuesWithoutReadyForDeploy = new HashSet<String>();
        for (Map.Entry entry : foundIssues.entrySet()) {
            if (((List)entry.getValue()).contains(R4DEPLOY_LABEL)) continue;
            issuesWithoutReadyForDeploy.add((String)entry.getKey());
        }
        return this.generateResultDto(issuesWithoutReadyForDeploy.stream().sorted().toList(), unknownIssues);
    }

    private DeploymentCheckResultDto generateResultDto(List<String> issuesWithoutReadyForDeploy, List<String> unknownIssues) {
        if (issuesWithoutReadyForDeploy.isEmpty()) {
            if (unknownIssues.isEmpty()) {
                return DeploymentCheckResultDto.builder().result(DeploymentCheckResult.OK).build();
            }
            return DeploymentCheckResultDto.builder().result(DeploymentCheckResult.WARNING).message("Issues not found: " + String.valueOf(unknownIssues)).build();
        }
        return DeploymentCheckResultDto.builder().result(DeploymentCheckResult.NOK).message("Issues without label: " + String.valueOf(issuesWithoutReadyForDeploy) + ". Issues not found: " + String.valueOf(unknownIssues)).build();
    }

    @Generated
    public DeploymentCheckService(JiraWebClient jiraWebClient) {
        this.jiraWebClient = jiraWebClient;
    }
}

