/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.deploymentlog.domain.Environment;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentComponentVersionStateRepository;
import ch.admin.bit.jeap.deploymentlog.domain.EnvironmentRepository;
import ch.admin.bit.jeap.deploymentlog.domain.exception.SystemNotFoundException;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.ComponentVersionSummaryDto;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/environment"})
public class EnvironmentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentController.class);
    private final EnvironmentRepository environmentRepository;
    private final EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository;

    @GetMapping(value={"/{environmentName}/components"})
    @Operation(summary="Get deployed components for environment")
    @PreAuthorize(value="hasAnyRole('deploymentlog-read','deploymentlog-write')")
    public List<ComponentVersionSummaryDto> getEnvironmentComponents(@PathVariable String environmentName) throws SystemNotFoundException {
        Environment environment = (Environment)this.environmentRepository.findByName(environmentName.toUpperCase()).orElseThrow();
        return this.environmentComponentVersionStateRepository.getDeployedComponentsOnEnvironment(environment).stream().map(ComponentVersionSummaryDto::from).toList();
    }

    @Generated
    public EnvironmentController(EnvironmentRepository environmentRepository, EnvironmentComponentVersionStateRepository environmentComponentVersionStateRepository) {
        this.environmentRepository = environmentRepository;
        this.environmentComponentVersionStateRepository = environmentComponentVersionStateRepository;
    }
}

