/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.deploymentlog.web.api;

import ch.admin.bit.jeap.deploymentlog.domain.ReferenceService;
import ch.admin.bit.jeap.deploymentlog.web.api.dto.ReferenceDto;
import io.swagger.v3.oas.annotations.Operation;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reference"})
public class ReferenceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReferenceController.class);
    private final ReferenceService referenceService;

    @PutMapping(value={"/{id}"})
    @Operation(summary="Save new reference")
    @PreAuthorize(value="hasRole('deploymentlog-write')")
    public ResponseEntity<Void> save(@PathVariable(name="id") UUID referenceId, @RequestBody ReferenceDto referenceDto) {
        log.debug("Save new reference {}", (Object)referenceDto);
        if (!referenceId.equals(referenceDto.getId())) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (this.referenceService.referenceExistsById(referenceId)) {
            log.info("Reference with id {} already exists", (Object)referenceId);
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        this.referenceService.saveReference(referenceId, referenceDto.getType(), referenceDto.getReferenceIdentifier(), referenceDto.getUri());
        log.info("Reference with id {} saved", (Object)referenceId);
        return new ResponseEntity((HttpStatusCode)HttpStatus.CREATED);
    }

    @Generated
    public ReferenceController(ReferenceService referenceService) {
        this.referenceService = referenceService;
    }
}

