/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedData;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroup;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ErrorGroupRepository
extends JpaRepository<ErrorGroup, UUID> {
    public static final String ERROR_GROUP_AGGREGATED_DATA_SELECTOR = "    SELECT eg.id as groupId, count(e.id) as errorCount,\n        eg.eventName as errorEvent, eg.errorPublisher as errorPublisher,\n        eg.errorCode as errorCode, eg.errorMessage as errorMessage,\n        min(e.created) as firstErrorAt,\n        max(e.created) as latestErrorAt,\n        eg.ticketNumber as ticketNumber, eg.freeText as freeText\n    FROM Error e\n    JOIN e.errorGroup eg\n    WHERE e.state IN ('SEND_TO_MANUALTASK', 'PERMANENT')\n";
    public static final String ERROR_GROUP_AGGREGATED_DATA_GROUPING = " GROUP BY eg.id, eg.eventName, eg.errorPublisher, eg.errorCode, eg.errorMessage, eg.freeText, eg.ticketNumber ";

    @Query(value="    SELECT eg.id as groupId, count(e.id) as errorCount,\n        eg.eventName as errorEvent, eg.errorPublisher as errorPublisher,\n        eg.errorCode as errorCode, eg.errorMessage as errorMessage,\n        min(e.created) as firstErrorAt,\n        max(e.created) as latestErrorAt,\n        eg.ticketNumber as ticketNumber, eg.freeText as freeText\n    FROM Error e\n    JOIN e.errorGroup eg\n    WHERE e.state IN ('SEND_TO_MANUALTASK', 'PERMANENT')\n GROUP BY eg.id, eg.eventName, eg.errorPublisher, eg.errorCode, eg.errorMessage, eg.freeText, eg.ticketNumber order by errorCount desc\noffset :#{#pageable.offset} rows\nfetch next :#{#pageable.pageSize} rows only", countQuery="select count(*) from ErrorGroup")
    public Page<ErrorGroupAggregatedData> findErrorGroupAggregatedData(Pageable var1);

    @Query(value="    SELECT eg.id as groupId, count(e.id) as errorCount,\n        eg.eventName as errorEvent, eg.errorPublisher as errorPublisher,\n        eg.errorCode as errorCode, eg.errorMessage as errorMessage,\n        min(e.created) as firstErrorAt,\n        max(e.created) as latestErrorAt,\n        eg.ticketNumber as ticketNumber, eg.freeText as freeText\n    FROM Error e\n    JOIN e.errorGroup eg\n    WHERE e.state IN ('SEND_TO_MANUALTASK', 'PERMANENT')\n AND eg.id = :id  GROUP BY eg.id, eg.eventName, eg.errorPublisher, eg.errorCode, eg.errorMessage, eg.freeText, eg.ticketNumber ")
    public Optional<ErrorGroupAggregatedData> findErrorGroupAggregatedData(@Param(value="id") UUID var1);

    public Optional<ErrorGroup> findByErrorPublisherAndErrorCodeAndEventNameAndErrorStackTraceHash(String var1, String var2, String var3, String var4);

    @Query(value="select errorGroup.id from ErrorGroup errorGroup left join Error error on errorGroup.id = error.errorGroup.id where error is null")
    public Slice<UUID> findUnreferencedErrorGroups(Pageable var1);

    public boolean existsByTicketNumber(String var1);
}

