/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.group;

import ch.admin.bit.jeap.errorhandling.domain.exceptions.ErrorGroupNotFoundException;
import ch.admin.bit.jeap.errorhandling.domain.exceptions.TicketNumberAlreadyExistsException;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedData;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupAggregatedDataList;
import ch.admin.bit.jeap.errorhandling.domain.group.ErrorGroupConfigProperties;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroup;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.ErrorGroupRepository;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class ErrorGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorGroupService.class);
    private final ErrorGroupConfigProperties errorGroupConfigProperties;
    private final ErrorGroupRepository errorGroupRepository;
    private final PlatformTransactionManager transactionManager;

    public ErrorGroup assignToErrorGroup(Error error) {
        if (this.errorGroupConfigProperties.isErrorGroupingEnabled() && StringUtils.hasText((String)error.getErrorEventData().getStackTraceHash())) {
            ErrorGroup errorGroup = this.findOrCreateMatchingErrorGroup(error);
            error.setErrorGroup(errorGroup);
            return errorGroup;
        }
        return null;
    }

    public ErrorGroup updateTicketNumber(UUID errorGroupId, String ticketNumber) {
        ErrorGroup errorGroup = this.findErrorGroup(errorGroupId);
        if (this.errorGroupRepository.existsByTicketNumber(ticketNumber)) {
            throw new TicketNumberAlreadyExistsException("Ticket number " + ticketNumber + " already exists");
        }
        errorGroup.setTicketNumber(ticketNumber);
        return errorGroup;
    }

    public ErrorGroup updateFreeText(UUID errorGroupId, String freeText) {
        ErrorGroup errorGroup = this.findErrorGroup(errorGroupId);
        errorGroup.setFreeText(freeText);
        return errorGroup;
    }

    public ErrorGroupAggregatedData getErrorGroupAggregatedData(UUID errorGroupId) {
        return this.errorGroupRepository.findErrorGroupAggregatedData(errorGroupId).orElseThrow(() -> new ErrorGroupNotFoundException(errorGroupId));
    }

    public ErrorGroupAggregatedDataList findErrorGroupAggregatedData(Pageable pageable) {
        Page<ErrorGroupAggregatedData> groupAggregatedData = this.errorGroupRepository.findErrorGroupAggregatedData(pageable);
        return new ErrorGroupAggregatedDataList(groupAggregatedData.getTotalElements(), groupAggregatedData.getContent());
    }

    private ErrorGroup findOrCreateMatchingErrorGroup(Error error) {
        ErrorGroup errorGroup = ErrorGroup.from(error);
        try {
            return this.saveOrGetErrorGroup(errorGroup);
        }
        catch (TransactionException e) {
            if (e.contains(DataIntegrityViolationException.class)) {
                return this.saveOrGetErrorGroup(errorGroup);
            }
            throw e;
        }
    }

    private ErrorGroup saveOrGetErrorGroup(ErrorGroup errorGroup) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (ErrorGroup)transactionTemplate.execute(status -> {
            Optional<ErrorGroup> existingErrorGroup = this.findMatchingErrorGroup(errorGroup);
            if (existingErrorGroup.isEmpty()) {
                log.debug("Creating new error group: {}.", (Object)errorGroup);
                return (ErrorGroup)this.errorGroupRepository.save(errorGroup);
            }
            log.debug("Found existing error group: {}.", (Object)existingErrorGroup.get());
            return existingErrorGroup.get();
        });
    }

    private ErrorGroup findErrorGroup(UUID errorGroupId) {
        return (ErrorGroup)this.errorGroupRepository.findById(errorGroupId).orElseThrow(() -> new ErrorGroupNotFoundException(errorGroupId));
    }

    private Optional<ErrorGroup> findMatchingErrorGroup(ErrorGroup errorGroup) {
        return this.errorGroupRepository.findByErrorPublisherAndErrorCodeAndEventNameAndErrorStackTraceHash(errorGroup.getErrorPublisher(), errorGroup.getErrorCode(), errorGroup.getEventName(), errorGroup.getErrorStackTraceHash());
    }

    @Generated
    public ErrorGroupService(ErrorGroupConfigProperties errorGroupConfigProperties, ErrorGroupRepository errorGroupRepository, PlatformTransactionManager transactionManager) {
        this.errorGroupConfigProperties = errorGroupConfigProperties;
        this.errorGroupRepository = errorGroupRepository;
        this.transactionManager = transactionManager;
    }
}

