/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.kafka;

import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.DomainEventDeserializerProvider;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DomainEventDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomainEventDeserializer.class);
    private final Map<String, Deserializer<GenericData.Record>> deserializersByClusterName;

    DomainEventDeserializer(KafkaProperties kafkaProperties, DomainEventDeserializerProvider domainEventDeserializerProvider) {
        this.deserializersByClusterName = kafkaProperties.clusterNames().stream().collect(Collectors.toMap(clusterName -> clusterName, domainEventDeserializerProvider::getGenericRecordDomainEventDeserializer));
    }

    public String toJsonString(String clusterName, String eventTopic, byte[] payload) throws IOException {
        Deserializer<GenericData.Record> deserializer = this.deserializersByClusterName.get(clusterName);
        GenericData.Record causingEvent = (GenericData.Record)deserializer.deserialize(eventTopic, payload);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(causingEvent.getSchema(), (OutputStream)output, true);
        GenericDatumWriter writer = new GenericDatumWriter(causingEvent.getSchema());
        writer.write((Object)causingEvent, (Encoder)encoder);
        encoder.flush();
        output.flush();
        return output.toString(StandardCharsets.UTF_8);
    }

    @PreDestroy
    private void closeKafkaAvroDeserializer() {
        this.deserializersByClusterName.values().forEach(Deserializer::close);
    }
}

