/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.housekeeping;

import ch.admin.bit.jeap.errorhandling.domain.housekeeping.HouseKeepingServiceConfigProperties;
import ch.admin.bit.jeap.errorhandling.domain.housekeeping.RepositoryHousekeeping;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HouseKeepingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HouseKeepingService.class);
    private final RepositoryHousekeeping repositoryHousekeeping;
    private final HouseKeepingServiceConfigProperties configProperties;

    public void cleanup() {
        this.deleteOldErrors();
        this.deleteOldCausingEvents();
        this.deleteOldErrorGroups();
    }

    private void deleteOldErrors() {
        ZonedDateTime olderThan = ZonedDateTime.now().minus(this.configProperties.getErrorMaxAge());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy - HH:mm:ss Z");
        log.info("Housekeeping: Delete Errors which are older than {} ({}) with State in {}", new Object[]{this.configProperties.getErrorMaxAge(), olderThan.format(formatter), RepositoryHousekeeping.ERROR_STATES});
        this.executeInTransactionPerPage(() -> this.repositoryHousekeeping.deleteErrorsOlderThan(olderThan));
        log.info("Housekeeping: Deleted all old errors");
    }

    private void deleteOldCausingEvents() {
        log.info("Housekeeping: Delete causing events without errors relation");
        this.executeInTransactionPerPage(this.repositoryHousekeeping::deleteCausingEventsWithoutRelatedErrors);
        log.info("Housekeeping: Deleted all old causing events");
    }

    private void deleteOldErrorGroups() {
        log.info("Housekeeping: Delete error groups without errors)");
        this.executeInTransactionPerPage(this.repositoryHousekeeping::deleteErrorGroupsNotReferencedByAnyError);
        log.info("Housekeeping: Deleted all old error groups");
    }

    private void executeInTransactionPerPage(Supplier<Boolean> callback) {
        boolean hasMorePages;
        for (int pages = 0; pages < this.configProperties.getMaxPages() && (hasMorePages = callback.get().booleanValue()); ++pages) {
        }
    }

    @Generated
    public HouseKeepingService(RepositoryHousekeeping repositoryHousekeeping, HouseKeepingServiceConfigProperties configProperties) {
        this.repositoryHousekeeping = repositoryHousekeeping;
        this.configProperties = configProperties;
    }
}

