/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.persistence;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class ErrorGroup {
    @Id
    @NonNull
    private UUID id;
    @NonNull
    private String errorCode;
    @NonNull
    private String eventName;
    @NonNull
    private String errorPublisher;
    @NonNull
    private String errorMessage;
    private String errorStackTraceHash;
    private String ticketNumber;
    private String freeText;
    @NonNull
    private ZonedDateTime created;
    private ZonedDateTime modified;

    public ErrorGroup(@NonNull String errorCode, @NonNull String eventName, @NonNull String errorPublisher, @NonNull String errorMessage, @NonNull String errorStackTraceHash) {
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        if (errorPublisher == null) {
            throw new NullPointerException("errorPublisher is marked non-null but is null");
        }
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        if (errorStackTraceHash == null) {
            throw new NullPointerException("errorStackTraceHash is marked non-null but is null");
        }
        this.id = UUID.randomUUID();
        this.created = ZonedDateTime.now();
        this.errorCode = errorCode;
        this.eventName = eventName;
        this.errorPublisher = errorPublisher;
        this.errorMessage = errorMessage;
        this.errorStackTraceHash = errorStackTraceHash;
    }

    public static ErrorGroup from(Error error) {
        return new ErrorGroup(error.getErrorEventData().getCode(), error.getCausingEventMetadata().getType().getName(), error.getErrorEventMetadata().getPublisher().getService(), error.getErrorEventData().getMessage(), error.getErrorEventData().getStackTraceHash());
    }

    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
        this.modifiedNow();
    }

    public void setFreeText(String freeText) {
        this.freeText = freeText;
        this.modifiedNow();
    }

    private void modifiedNow() {
        this.modified = ZonedDateTime.now();
    }

    @NonNull
    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    @NonNull
    @Generated
    public String getEventName() {
        return this.eventName;
    }

    @NonNull
    @Generated
    public String getErrorPublisher() {
        return this.errorPublisher;
    }

    @NonNull
    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public String getErrorStackTraceHash() {
        return this.errorStackTraceHash;
    }

    @Generated
    public String getTicketNumber() {
        return this.ticketNumber;
    }

    @Generated
    public String getFreeText() {
        return this.freeText;
    }

    @NonNull
    @Generated
    public ZonedDateTime getCreated() {
        return this.created;
    }

    @Generated
    public ZonedDateTime getModified() {
        return this.modified;
    }

    @Generated
    ErrorGroup(@NonNull UUID id, @NonNull String errorCode, @NonNull String eventName, @NonNull String errorPublisher, @NonNull String errorMessage, String errorStackTraceHash, String ticketNumber, String freeText, @NonNull ZonedDateTime created, ZonedDateTime modified) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        if (errorPublisher == null) {
            throw new NullPointerException("errorPublisher is marked non-null but is null");
        }
        if (errorMessage == null) {
            throw new NullPointerException("errorMessage is marked non-null but is null");
        }
        if (created == null) {
            throw new NullPointerException("created is marked non-null but is null");
        }
        this.id = id;
        this.errorCode = errorCode;
        this.eventName = eventName;
        this.errorPublisher = errorPublisher;
        this.errorMessage = errorMessage;
        this.errorStackTraceHash = errorStackTraceHash;
        this.ticketNumber = ticketNumber;
        this.freeText = freeText;
        this.created = created;
        this.modified = modified;
    }

    @Generated
    public ErrorGroup() {
    }

    @Generated
    public String toString() {
        return "ErrorGroup(id=" + String.valueOf(this.getId()) + ", errorCode=" + this.getErrorCode() + ", eventName=" + this.getEventName() + ", errorPublisher=" + this.getErrorPublisher() + ", errorMessage=" + this.getErrorMessage() + ", errorStackTraceHash=" + this.getErrorStackTraceHash() + ", ticketNumber=" + this.getTicketNumber() + ", freeText=" + this.getFreeText() + ", created=" + String.valueOf(this.getCreated()) + ", modified=" + String.valueOf(this.getModified()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorGroup)) {
            return false;
        }
        ErrorGroup other = (ErrorGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$eventName = this.getEventName();
        String other$eventName = other.getEventName();
        if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
            return false;
        }
        String this$errorPublisher = this.getErrorPublisher();
        String other$errorPublisher = other.getErrorPublisher();
        if (this$errorPublisher == null ? other$errorPublisher != null : !this$errorPublisher.equals(other$errorPublisher)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$errorStackTraceHash = this.getErrorStackTraceHash();
        String other$errorStackTraceHash = other.getErrorStackTraceHash();
        if (this$errorStackTraceHash == null ? other$errorStackTraceHash != null : !this$errorStackTraceHash.equals(other$errorStackTraceHash)) {
            return false;
        }
        String this$ticketNumber = this.getTicketNumber();
        String other$ticketNumber = other.getTicketNumber();
        if (this$ticketNumber == null ? other$ticketNumber != null : !this$ticketNumber.equals(other$ticketNumber)) {
            return false;
        }
        String this$freeText = this.getFreeText();
        String other$freeText = other.getFreeText();
        if (this$freeText == null ? other$freeText != null : !this$freeText.equals(other$freeText)) {
            return false;
        }
        ZonedDateTime this$created = this.getCreated();
        ZonedDateTime other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        ZonedDateTime this$modified = this.getModified();
        ZonedDateTime other$modified = other.getModified();
        return !(this$modified == null ? other$modified != null : !((Object)this$modified).equals(other$modified));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErrorGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $eventName = this.getEventName();
        result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
        String $errorPublisher = this.getErrorPublisher();
        result = result * 59 + ($errorPublisher == null ? 43 : $errorPublisher.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $errorStackTraceHash = this.getErrorStackTraceHash();
        result = result * 59 + ($errorStackTraceHash == null ? 43 : $errorStackTraceHash.hashCode());
        String $ticketNumber = this.getTicketNumber();
        result = result * 59 + ($ticketNumber == null ? 43 : $ticketNumber.hashCode());
        String $freeText = this.getFreeText();
        result = result * 59 + ($freeText == null ? 43 : $freeText.hashCode());
        ZonedDateTime $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        ZonedDateTime $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : ((Object)$modified).hashCode());
        return result;
    }
}

