/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.infrastructure.kafka;

import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.ErrorEventHandler;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.MessageProcessingFailedEventListener;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.TopicConfiguration;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.converters.ProcessingFailedEventConverter;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaBeanNames;
import ch.admin.bit.jeap.messaging.kafka.spring.JeapKafkaPropertyFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
class KafkaMessageProcessingFailedEventConsumerFactory
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware,
EnvironmentAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaMessageProcessingFailedEventConsumerFactory.class);
    private Environment environment;
    private BeanFactory beanFactory;
    private String defaultClusterName;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        KafkaProperties kafkaProperties = JeapKafkaPropertyFactory.createJeapKafkaProperties((Environment)this.environment);
        this.defaultClusterName = kafkaProperties.getDefaultClusterName();
        kafkaProperties.clusterNames().forEach(clusterName -> this.registerConsumerContainerBeanDefinition(registry, (String)clusterName));
    }

    private void registerConsumerContainerBeanDefinition(BeanDefinitionRegistry registry, String clusterName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(ConcurrentMessageListenerContainer.class);
        beanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)clusterName));
        beanDefinition.setInstanceSupplier(() -> this.createContainer(clusterName));
        registry.registerBeanDefinition("message-processing-failed-container-" + clusterName, (BeanDefinition)beanDefinition);
    }

    private ConcurrentKafkaListenerContainerFactory<?, ?> getContainerFactory(String clusterName) {
        String listenerContainerFactoryBeanName = new JeapKafkaBeanNames(this.defaultClusterName).getListenerContainerFactoryBeanName(clusterName);
        return (ConcurrentKafkaListenerContainerFactory)this.beanFactory.getBean(listenerContainerFactoryBeanName);
    }

    private ConcurrentMessageListenerContainer<?, ?> createContainer(String clusterName) {
        TopicConfiguration topicConfiguration = (TopicConfiguration)this.beanFactory.getBean(TopicConfiguration.class);
        ConcurrentMessageListenerContainer container = (ConcurrentMessageListenerContainer)this.getContainerFactory(clusterName).createContainer(new String[]{topicConfiguration.getTopicName()});
        ErrorEventHandler errorEventHandler = (ErrorEventHandler)this.beanFactory.getBean(ErrorEventHandler.class);
        ProcessingFailedEventConverter processingFailedEventConverter = (ProcessingFailedEventConverter)this.beanFactory.getBean(ProcessingFailedEventConverter.class);
        MessageProcessingFailedEventListener listener = new MessageProcessingFailedEventListener(processingFailedEventConverter, errorEventHandler, clusterName);
        container.setupMessageListener((Object)listener);
        return container;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    @Generated
    public KafkaMessageProcessingFailedEventConsumerFactory() {
    }

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

