/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.audit;

import ch.admin.bit.jeap.errorhandling.domain.audit.AuditLogException;
import ch.admin.bit.jeap.errorhandling.domain.user.UserService;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.AuditLog;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.AuditLogRepository;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.User;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AuditLogService {
    private final UserService userService;
    private final AuditLogRepository auditLogRepository;

    public void logResendCausingEvent(Error error) {
        this.logAction(error.getId(), AuditLog.AuditedAction.RESEND_CAUSING_EVENT);
    }

    public void logDeleteError(Error error) {
        this.logAction(error.getId(), AuditLog.AuditedAction.DELETE_ERROR);
    }

    public List<AuditLog> getAuditLogs(UUID errorId) {
        return this.auditLogRepository.findAllByErrorId(errorId);
    }

    private void logAction(UUID errorId, AuditLog.AuditedAction action) {
        User user = this.userService.getAuthenticatedUser().orElseThrow(AuditLogException::noAuthenticatedUserException);
        AuditLog auditLog = AuditLog.builder().user(user).errorId(errorId).action(action).created(ZonedDateTime.now()).build();
        this.auditLogRepository.save(auditLog);
    }

    @Generated
    public AuditLogService(UserService userService, AuditLogRepository auditLogRepository) {
        this.userService = userService;
        this.auditLogRepository = auditLogRepository;
    }
}

