/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.web.api;

import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class ErrorSearchCriteria {
    public static final Integer PAGE_DEFAULT_VALUE = 0;
    public static final Integer SIZE_DEFAULT_VALUE = 10;
    private ZonedDateTime from;
    private ZonedDateTime to;
    private String eventName;
    private String traceId;
    private String eventId;
    private String serviceName;
    private List<Error.ErrorState> states;
    private String errorCode;
    private Integer pageIndex;
    private Integer pageSize;
    private String[] sort;
    private Pattern stacktracePattern;
    private String closingReason;
    private String ticketNumber;

    public Optional<ZonedDateTime> getFrom() {
        return Optional.ofNullable(this.from);
    }

    public Optional<ZonedDateTime> getTo() {
        return Optional.ofNullable(this.to);
    }

    public Optional<String> getEventName() {
        return Optional.ofNullable(this.eventName);
    }

    public Optional<String> getTraceId() {
        return Optional.ofNullable(this.traceId);
    }

    public Optional<String> getEventId() {
        return Optional.ofNullable(this.eventId);
    }

    public Optional<String> getServiceName() {
        return Optional.ofNullable(this.serviceName);
    }

    public Optional<List<Error.ErrorState>> getStates() {
        return Optional.ofNullable(this.states);
    }

    public Optional<String> getErrorCode() {
        return Optional.ofNullable(this.errorCode);
    }

    public Optional<Pattern> getStacktrace() {
        return Optional.ofNullable(this.stacktracePattern);
    }

    public Optional<String> getClosingReason() {
        return Optional.ofNullable(this.closingReason);
    }

    public Optional<String> getTicketNumber() {
        return Optional.ofNullable(this.ticketNumber);
    }

    @JsonIgnore
    public Pageable getPageable() {
        return PageRequest.of((int)((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.pageIndex, PAGE_DEFAULT_VALUE})), (int)((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.pageSize, SIZE_DEFAULT_VALUE})), (Sort)Sort.by(this.getOrders()));
    }

    private List<Sort.Order> getOrders() {
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        if (this.hasMultipleColumns()) {
            for (String sortOrder : this.sort) {
                Object[] propertyDirection = sortOrder.split(",");
                Assert.isTrue((boolean)this.hasPropertyAndDirection((String[])propertyDirection), (String)String.format("Invalid sort value '%s' ", Arrays.toString(propertyDirection)));
                orders.add(new Sort.Order(this.getDirection((String)propertyDirection[1]), (String)propertyDirection[0]));
            }
        } else {
            Assert.isTrue((boolean)this.hasPropertyAndDirection(this.sort), (String)String.format("Invalid sort value '%s' ", Arrays.toString(this.sort)));
            orders.add(new Sort.Order(this.getDirection(this.sort[1]), this.sort[0]));
        }
        return orders;
    }

    private boolean hasPropertyAndDirection(String[] array) {
        return array.length == 2;
    }

    private boolean hasMultipleColumns() {
        return this.sort[0].contains(",");
    }

    private Sort.Direction getDirection(String direction) {
        return Sort.Direction.fromString((String)direction);
    }

    @Generated
    ErrorSearchCriteria(ZonedDateTime from, ZonedDateTime to, String eventName, String traceId, String eventId, String serviceName, List<Error.ErrorState> states, String errorCode, Integer pageIndex, Integer pageSize, String[] sort, Pattern stacktracePattern, String closingReason, String ticketNumber) {
        this.from = from;
        this.to = to;
        this.eventName = eventName;
        this.traceId = traceId;
        this.eventId = eventId;
        this.serviceName = serviceName;
        this.states = states;
        this.errorCode = errorCode;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.sort = sort;
        this.stacktracePattern = stacktracePattern;
        this.closingReason = closingReason;
        this.ticketNumber = ticketNumber;
    }

    @Generated
    public static ErrorSearchCriteriaBuilder builder() {
        return new ErrorSearchCriteriaBuilder();
    }

    @Generated
    public static class ErrorSearchCriteriaBuilder {
        @Generated
        private ZonedDateTime from;
        @Generated
        private ZonedDateTime to;
        @Generated
        private String eventName;
        @Generated
        private String traceId;
        @Generated
        private String eventId;
        @Generated
        private String serviceName;
        @Generated
        private List<Error.ErrorState> states;
        @Generated
        private String errorCode;
        @Generated
        private Integer pageIndex;
        @Generated
        private Integer pageSize;
        @Generated
        private String[] sort;
        @Generated
        private Pattern stacktracePattern;
        @Generated
        private String closingReason;
        @Generated
        private String ticketNumber;

        @Generated
        ErrorSearchCriteriaBuilder() {
        }

        @Generated
        public ErrorSearchCriteriaBuilder from(ZonedDateTime from) {
            this.from = from;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder to(ZonedDateTime to) {
            this.to = to;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder states(List<Error.ErrorState> states) {
            this.states = states;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder pageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder sort(String[] sort) {
            this.sort = sort;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder stacktracePattern(Pattern stacktracePattern) {
            this.stacktracePattern = stacktracePattern;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder closingReason(String closingReason) {
            this.closingReason = closingReason;
            return this;
        }

        @Generated
        public ErrorSearchCriteriaBuilder ticketNumber(String ticketNumber) {
            this.ticketNumber = ticketNumber;
            return this;
        }

        @Generated
        public ErrorSearchCriteria build() {
            return new ErrorSearchCriteria(this.from, this.to, this.eventName, this.traceId, this.eventId, this.serviceName, this.states, this.errorCode, this.pageIndex, this.pageSize, this.sort, this.stacktracePattern, this.closingReason, this.ticketNumber);
        }

        @Generated
        public String toString() {
            return "ErrorSearchCriteria.ErrorSearchCriteriaBuilder(from=" + String.valueOf(this.from) + ", to=" + String.valueOf(this.to) + ", eventName=" + this.eventName + ", traceId=" + this.traceId + ", eventId=" + this.eventId + ", serviceName=" + this.serviceName + ", states=" + String.valueOf(this.states) + ", errorCode=" + this.errorCode + ", pageIndex=" + this.pageIndex + ", pageSize=" + this.pageSize + ", sort=" + Arrays.deepToString(this.sort) + ", stacktracePattern=" + String.valueOf(this.stacktracePattern) + ", closingReason=" + this.closingReason + ", ticketNumber=" + this.ticketNumber + ")";
        }
    }
}

