/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.domain.eventHandler;

import ch.admin.bit.jeap.errorhandling.domain.error.ErrorService;
import ch.admin.bit.jeap.errorhandling.domain.eventHandler.ErrorEventMapper;
import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.ErrorEventHandler;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.CausingEvent;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.CausingEventRepository;
import ch.admin.bit.jeap.errorhandling.infrastructure.persistence.Error;
import ch.admin.bit.jeap.messaging.avro.errorevent.MessageProcessingFailedEvent;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ErrorEventHandlerService
implements ErrorEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorEventHandlerService.class);
    private final ErrorService errorService;
    private final CausingEventRepository causingEventRepository;
    private final ErrorEventMapper errorEventMapper;
    private final PlatformTransactionManager transactionManager;

    @Override
    public void handle(String clusterName, MessageProcessingFailedEvent errorEvent) {
        if (this.errorService.isEventDuplicate(errorEvent.getIdentity().getIdempotenceId())) {
            log.info("Received an error event with an already handled idempotence ID. Skipping this event: {}.", (Object)errorEvent);
            return;
        }
        CausingEvent causingEvent = this.createOrGetCausingEvent(clusterName, errorEvent);
        Error error = this.errorEventMapper.toError(errorEvent, causingEvent);
        switch (error.getErrorEventData().getTemporality()) {
            case TEMPORARY: {
                this.errorService.handleTemporaryError(error);
                break;
            }
            case PERMANENT: {
                this.errorService.handlePermanentError(error);
                break;
            }
            default: {
                this.errorService.handleUnknownTemporalityError(error);
            }
        }
    }

    private CausingEvent createOrGetCausingEvent(String clusterName, MessageProcessingFailedEvent errorEvent) {
        CausingEvent causingEvent = this.errorEventMapper.toCausingEvent(clusterName, errorEvent);
        try {
            return this.saveOrGetCausingEvent(causingEvent);
        }
        catch (TransactionException ex) {
            if (ex.contains(DataIntegrityViolationException.class)) {
                return this.saveOrGetCausingEvent(causingEvent);
            }
            throw ex;
        }
    }

    private CausingEvent saveOrGetCausingEvent(CausingEvent causingEvent) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (CausingEvent)transactionTemplate.execute(status -> {
            Optional<CausingEvent> persistentCausingEvent = this.causingEventRepository.findByCausingEventId(causingEvent.getMetadata().getId());
            if (persistentCausingEvent.isEmpty()) {
                log.debug("New causing event: {}.", (Object)causingEvent);
                return (CausingEvent)this.causingEventRepository.save(causingEvent);
            }
            log.debug("Existing causing event: {}.", (Object)causingEvent);
            return persistentCausingEvent.get();
        });
    }

    @Generated
    public ErrorEventHandlerService(ErrorService errorService, CausingEventRepository causingEventRepository, ErrorEventMapper errorEventMapper, PlatformTransactionManager transactionManager) {
        this.errorService = errorService;
        this.causingEventRepository = causingEventRepository;
        this.errorEventMapper = errorEventMapper;
        this.transactionManager = transactionManager;
    }
}

