/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.errorhandling.web.api;

import ch.admin.bit.jeap.errorhandling.infrastructure.kafka.KafkaDeadLetterBatchConsumerProducer;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Tag(name="DeadLetterReactivation")
@RestController
@RequestMapping(value={"/api/deadletter"})
public class DeadLetterReactivationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeadLetterReactivationController.class);
    private final KafkaDeadLetterBatchConsumerProducer kafkaDeadLetterBatchConsumerProducer;

    public DeadLetterReactivationController(KafkaDeadLetterBatchConsumerProducer kafkaDeadLetterBatchConsumerProducer) {
        this.kafkaDeadLetterBatchConsumerProducer = kafkaDeadLetterBatchConsumerProducer;
    }

    @Schema(description="Reactivates messages from the dead-letter queue and produces them to the target topic")
    @PostMapping(value={"/reactivate"})
    @PreAuthorize(value="hasRole('error','retry')")
    public void reactivateDeadLetters(@RequestParam int maxRecords) {
        if (maxRecords < 1 || maxRecords > 500) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "maxRecords must be between 1 and 500");
        }
        log.info("Starting dead-letter reactivation process with maxRecords={}", (Object)maxRecords);
        CompletableFuture.runAsync(() -> this.kafkaDeadLetterBatchConsumerProducer.consumeAndProduce(maxRecords)).join();
        log.info("Dead-letter reactivation process completed");
    }
}

